/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockFluidPipe;
import cassiokf.industrialrenewal.blocks.pipes.BlockPipeBase;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.properties.PropertyBaseDirection;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityCableTray;
import cassiokf.industrialrenewal.util.enums.EnumCableIn;
import cassiokf.industrialrenewal.util.enums.enumproperty.EnumBaseDirection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockCableTray
extends BlockPipeBase<TileEntityCableTray> {
    public static final IProperty<EnumBaseDirection> BASE = PropertyBaseDirection.create("base");
    public static final IUnlistedProperty<Boolean> PIPE_CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_core"));
    public static final IUnlistedProperty<Boolean> PIPE_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_north"));
    public static final IUnlistedProperty<Boolean> PIPE_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_south"));
    public static final IUnlistedProperty<Boolean> PIPE_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_east"));
    public static final IUnlistedProperty<Boolean> PIPE_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_west"));
    public static final IUnlistedProperty<Boolean> PIPE_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_up"));
    public static final IUnlistedProperty<Boolean> PIPE_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_down"));
    public static final IUnlistedProperty<Boolean> PIPE2_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_north"));
    public static final IUnlistedProperty<Boolean> PIPE2_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_south"));
    public static final IUnlistedProperty<Boolean> PIPE2_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_east"));
    public static final IUnlistedProperty<Boolean> PIPE2_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_west"));
    public static final IUnlistedProperty<Boolean> PIPE2_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_up"));
    public static final IUnlistedProperty<Boolean> PIPE2_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_down"));
    public static final IUnlistedProperty<Boolean> HV_CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_core"));
    public static final IUnlistedProperty<Boolean> HV2_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_north"));
    public static final IUnlistedProperty<Boolean> HV2_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_south"));
    public static final IUnlistedProperty<Boolean> HV2_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_east"));
    public static final IUnlistedProperty<Boolean> HV2_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_west"));
    public static final IUnlistedProperty<Boolean> HV2_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_up"));
    public static final IUnlistedProperty<Boolean> HV2_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_down"));
    public static final IUnlistedProperty<Boolean> MV_CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_core"));
    public static final IUnlistedProperty<Boolean> MV_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_north"));
    public static final IUnlistedProperty<Boolean> MV_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_south"));
    public static final IUnlistedProperty<Boolean> MV_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_east"));
    public static final IUnlistedProperty<Boolean> MV_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_west"));
    public static final IUnlistedProperty<Boolean> MV_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_up"));
    public static final IUnlistedProperty<Boolean> MV_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_down"));
    public static final IUnlistedProperty<Boolean> MV2_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_north"));
    public static final IUnlistedProperty<Boolean> MV2_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_south"));
    public static final IUnlistedProperty<Boolean> MV2_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_east"));
    public static final IUnlistedProperty<Boolean> MV2_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_west"));
    public static final IUnlistedProperty<Boolean> MV2_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_up"));
    public static final IUnlistedProperty<Boolean> MV2_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_down"));
    public static final IUnlistedProperty<Boolean> LV_CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe_core"));
    public static final IUnlistedProperty<Boolean> LV2_NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_north"));
    public static final IUnlistedProperty<Boolean> LV2_SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_south"));
    public static final IUnlistedProperty<Boolean> LV2_EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_east"));
    public static final IUnlistedProperty<Boolean> LV2_WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_west"));
    public static final IUnlistedProperty<Boolean> LV2_UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_up"));
    public static final IUnlistedProperty<Boolean> LV2_DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"pipe2_down"));
    public static final IUnlistedProperty<Boolean> DATA_CORE = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"data_core"));

    public BlockCableTray(String name, CreativeTabs tab) {
        super(name, tab);
        this.func_180632_j(this.func_176223_P().func_177226_a(BASE, (Comparable)((Object)EnumBaseDirection.NONE)));
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Can place energy Cable and Fluid Pipe in one block");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            TileEntity te;
            Item item = playerIn.func_184614_ca().func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if ((item instanceof ItemPowerScrewDrive || block instanceof BlockFluidPipe || block instanceof BlockEnergyCable) && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCableTray) {
                boolean change = ((TileEntityCableTray)te).onBlockActivated(playerIn, playerIn.func_184614_ca());
                if (change) {
                    worldIn.func_184138_a(pos, state, state, 3);
                }
                return change;
            }
        }
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{BASE};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{MASTER, SOUTH, NORTH, EAST, WEST, UP, DOWN, PIPE_CORE, PIPE_NORTH, PIPE_SOUTH, PIPE_EAST, PIPE_WEST, PIPE_UP, PIPE_DOWN, PIPE2_NORTH, PIPE2_SOUTH, PIPE2_EAST, PIPE2_WEST, PIPE2_UP, PIPE2_DOWN, HV_CORE, HV2_NORTH, HV2_SOUTH, HV2_EAST, HV2_WEST, HV2_UP, HV2_DOWN, MV_CORE, MV_NORTH, MV_SOUTH, MV_EAST, MV_WEST, MV_UP, MV_DOWN, MV2_NORTH, MV2_SOUTH, MV2_EAST, MV2_WEST, MV2_UP, MV2_DOWN, LV_CORE, LV2_NORTH, LV2_SOUTH, LV2_EAST, LV2_WEST, LV2_UP, LV2_DOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumBaseDirection direction = EnumBaseDirection.NONE;
        Block block = world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c();
        if (!(block instanceof BlockCableTray)) {
            direction = EnumBaseDirection.byIndex(facing.func_176734_d().func_176745_a());
        }
        return this.func_176223_P().func_177226_a(BASE, (Comparable)((Object)direction));
    }

    @Override
    public boolean canConnectToPipe(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        IBlockState state = worldIn.func_180495_p(ownPos.func_177972_a(neighbourDirection));
        return state.func_177230_c() instanceof BlockCableTray;
    }

    @Override
    public boolean canConnectToCapability(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos pos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockFluidPipe;
    }

    private boolean canConnectToEnergyCapability(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection, EnumCableIn type) {
        BlockPos pos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof BlockEnergyCable && type.equals((Object)BlockEnergyCable.convertFromType(((BlockEnergyCable)block).type));
    }

    private boolean canConnectFluidPipeTrayToTray(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        TileEntity otherTE = worldIn.func_175625_s(ownPos.func_177972_a(neighbourDirection));
        if (otherTE instanceof TileEntityCableTray) {
            return ((TileEntityCableTray)otherTE).hasPipe();
        }
        return false;
    }

    private boolean isPipePresent(IBlockAccess world, BlockPos pos) {
        TileEntityCableTray te = (TileEntityCableTray)world.func_175625_s(pos);
        if (te != null) {
            return te.hasPipe();
        }
        return false;
    }

    public boolean isCablePresent(IBlockAccess world, BlockPos pos, EnumCableIn type) {
        TileEntityCableTray te = (TileEntityCableTray)world.func_175625_s(pos);
        if (te != null) {
            return te.getCableIn().equals((Object)type);
        }
        return false;
    }

    private boolean canConnectCableTrayToTray(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        TileEntity thisTE = worldIn.func_175625_s(ownPos);
        TileEntity otherTE = worldIn.func_175625_s(ownPos.func_177972_a(neighbourDirection));
        if (thisTE instanceof TileEntityCableTray && otherTE instanceof TileEntityCableTray) {
            return ((TileEntityCableTray)thisTE).getCableIn().equals((Object)((TileEntityCableTray)otherTE).getCableIn());
        }
        return false;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            boolean isHvPresent = this.isCablePresent(world, pos, EnumCableIn.HV);
            boolean isMvPresent = this.isCablePresent(world, pos, EnumCableIn.MV);
            boolean isLvPresent = this.isCablePresent(world, pos, EnumCableIn.LV);
            boolean isPresent = isHvPresent || isMvPresent || isLvPresent;
            boolean isPipePresent = this.isPipePresent(world, pos);
            return eState.withProperty(MASTER, (Object)this.isMaster(world, pos)).withProperty(SOUTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.SOUTH)).withProperty(NORTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.NORTH)).withProperty(EAST, (Object)this.canConnectToPipe(world, pos, EnumFacing.EAST)).withProperty(WEST, (Object)this.canConnectToPipe(world, pos, EnumFacing.WEST)).withProperty(UP, (Object)this.canConnectToPipe(world, pos, EnumFacing.UP)).withProperty(DOWN, (Object)this.canConnectToPipe(world, pos, EnumFacing.DOWN)).withProperty(PIPE_CORE, (Object)isPipePresent).withProperty(PIPE_NORTH, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.NORTH) ? 1 : 0)).withProperty(PIPE_SOUTH, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.SOUTH) ? 1 : 0)).withProperty(PIPE_EAST, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.EAST) ? 1 : 0)).withProperty(PIPE_WEST, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.WEST) ? 1 : 0)).withProperty(PIPE_UP, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.UP) ? 1 : 0)).withProperty(PIPE_DOWN, (Object)(isPipePresent && this.canConnectFluidPipeTrayToTray(world, pos, EnumFacing.DOWN) ? 1 : 0)).withProperty(PIPE2_NORTH, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.NORTH) ? 1 : 0)).withProperty(PIPE2_SOUTH, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.SOUTH) ? 1 : 0)).withProperty(PIPE2_EAST, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.EAST) ? 1 : 0)).withProperty(PIPE2_WEST, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.WEST) ? 1 : 0)).withProperty(PIPE2_UP, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.UP) ? 1 : 0)).withProperty(PIPE2_DOWN, (Object)(isPipePresent && this.canConnectToCapability(world, pos, EnumFacing.DOWN) ? 1 : 0)).withProperty(HV_CORE, (Object)isHvPresent).withProperty(HV2_NORTH, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.NORTH, EnumCableIn.HV) ? 1 : 0)).withProperty(HV2_SOUTH, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.SOUTH, EnumCableIn.HV) ? 1 : 0)).withProperty(HV2_EAST, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.EAST, EnumCableIn.HV) ? 1 : 0)).withProperty(HV2_WEST, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.WEST, EnumCableIn.HV) ? 1 : 0)).withProperty(HV2_UP, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.UP, EnumCableIn.HV) ? 1 : 0)).withProperty(HV2_DOWN, (Object)(isHvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.DOWN, EnumCableIn.HV) ? 1 : 0)).withProperty(MV_CORE, (Object)isMvPresent).withProperty(MV_NORTH, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.NORTH) ? 1 : 0)).withProperty(MV_SOUTH, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.SOUTH) ? 1 : 0)).withProperty(MV_EAST, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.EAST) ? 1 : 0)).withProperty(MV_WEST, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.WEST) ? 1 : 0)).withProperty(MV_UP, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.UP) ? 1 : 0)).withProperty(MV_DOWN, (Object)(isPresent && this.canConnectCableTrayToTray(world, pos, EnumFacing.DOWN) ? 1 : 0)).withProperty(MV2_NORTH, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.NORTH, EnumCableIn.MV) ? 1 : 0)).withProperty(MV2_SOUTH, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.SOUTH, EnumCableIn.MV) ? 1 : 0)).withProperty(MV2_EAST, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.EAST, EnumCableIn.MV) ? 1 : 0)).withProperty(MV2_WEST, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.WEST, EnumCableIn.MV) ? 1 : 0)).withProperty(MV2_UP, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.UP, EnumCableIn.MV) ? 1 : 0)).withProperty(MV2_DOWN, (Object)(isMvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.DOWN, EnumCableIn.MV) ? 1 : 0)).withProperty(LV_CORE, (Object)isLvPresent).withProperty(LV2_NORTH, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.NORTH, EnumCableIn.LV) ? 1 : 0)).withProperty(LV2_SOUTH, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.SOUTH, EnumCableIn.LV) ? 1 : 0)).withProperty(LV2_EAST, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.EAST, EnumCableIn.LV) ? 1 : 0)).withProperty(LV2_WEST, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.WEST, EnumCableIn.LV) ? 1 : 0)).withProperty(LV2_UP, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.UP, EnumCableIn.LV) ? 1 : 0)).withProperty(LV2_DOWN, (Object)(isLvPresent && this.canConnectToEnergyCapability(world, pos, EnumFacing.DOWN, EnumCableIn.LV) ? 1 : 0));
        }
        return state;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockCableTray.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185505_j;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASE, (Comparable)((Object)EnumBaseDirection.byIndex(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumBaseDirection)((Object)state.func_177229_b(BASE))).getIndex();
    }

    @Override
    @Nullable
    public TileEntityCableTray createTileEntity(World world, IBlockState state) {
        return new TileEntityCableTray();
    }
}

