/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.abstracts;

import cassiokf.industrialrenewal.blocks.abstracts.BlockMultiBlockBase;
import cassiokf.industrialrenewal.tileentity.abstracts.TEMultiTankBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMultiTankBase<T extends TEMultiTankBase>
extends BlockMultiBlockBase<T> {
    public static final PropertyInteger TOP = PropertyInteger.func_177719_a((String)"top", (int)0, (int)2);
    public static final PropertyInteger DOWN = PropertyInteger.func_177719_a((String)"bot", (int)0, (int)2);

    public BlockMultiTankBase(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public List<BlockPos> getMachineBlockPosList(BlockPos masterPos, EnumFacing facing) {
        return MachinesUtils.getBlocksIn3x3x3Centered(masterPos);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER, TOP, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isMaster = (Boolean)state.func_177229_b((IProperty)MASTER);
        return state.func_177226_a((IProperty)TOP, (Comparable)Integer.valueOf(isMaster ? this.isTop(worldIn, pos) : 0)).func_177226_a((IProperty)DOWN, (Comparable)Integer.valueOf(isMaster ? this.isBot(worldIn, pos) : 0));
    }

    private int isTop(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177967_a(EnumFacing.UP, 3));
        boolean thereIsOnTop = this.instanceOf(state.func_177230_c()) && (Boolean)state.func_177229_b((IProperty)MASTER) != false;
        return thereIsOnTop ? 2 : 1;
    }

    protected int isBot(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 3));
        boolean thereIsOnBottom = this.instanceOf(state.func_177230_c()) && (Boolean)state.func_177229_b((IProperty)MASTER) != false;
        return thereIsOnBottom ? 2 : 1;
    }

    public abstract boolean instanceOf(Block var1);

    @Override
    @Nullable
    public abstract T createTileEntity(World var1, IBlockState var2);
}

