/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCatwalkGate
extends BlockHorizontalFacing {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    protected static final AxisAlignedBB RNORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB RSOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB RWEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB REAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.5, 0.03125);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.96875, 1.0, 1.5, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.03125, 1.5, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.96875, 0.0, 0.0, 1.0, 1.5, 1.0);
    protected static final AxisAlignedBB FRONT_LEFT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.5, 0.125);
    protected static final AxisAlignedBB FRONT_RIGHT_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.5, 0.125);
    protected static final AxisAlignedBB BACK_LEFT_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 0.125, 1.5, 1.0);
    protected static final AxisAlignedBB BACK_RIGHT_AABB = new AxisAlignedBB(0.875, 0.0, 0.875, 1.0, 1.5, 1.0);

    public BlockCatwalkGate(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149711_c(0.8f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Random r = new Random();
        float pitch = r.nextFloat() * 0.20000005f + 0.9f;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            world.func_184133_a(null, pos, IRSoundRegister.BLOCK_CATWALKGATE_CLOSE, SoundCategory.NEUTRAL, 1.0f * IRConfig.MainConfig.Sounds.masterVolumeMult, pitch);
        } else {
            world.func_184133_a(null, pos, IRSoundRegister.BLOCK_CATWALKGATE_OPEN, SoundCategory.NEUTRAL, 1.0f * IRConfig.MainConfig.Sounds.masterVolumeMult, pitch);
        }
        state = state.func_177231_a((IProperty)ACTIVE);
        world.func_180501_a(pos, state, 3);
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)ACTIVE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (face == EnumFacing.NORTH) {
            return RNORTH_AABB;
        }
        if (face == EnumFacing.SOUTH) {
            return RSOUTH_AABB;
        }
        if (face == EnumFacing.WEST) {
            return RWEST_AABB;
        }
        if (face == EnumFacing.EAST) {
            return REAST_AABB;
        }
        return RNORTH_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        Boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE);
        if (!active.booleanValue()) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
            } else if (face == EnumFacing.SOUTH) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            } else if (face == EnumFacing.WEST) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            } else if (face == EnumFacing.EAST) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
        } else if (active.booleanValue()) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRONT_LEFT_AABB);
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRONT_RIGHT_AABB);
            } else if (face == EnumFacing.SOUTH) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BACK_LEFT_AABB);
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BACK_RIGHT_AABB);
            } else if (face == EnumFacing.WEST) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRONT_LEFT_AABB);
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BACK_LEFT_AABB);
            } else if (face == EnumFacing.EAST) {
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FRONT_RIGHT_AABB);
                BlockCatwalkGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BACK_RIGHT_AABB);
            }
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

