/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.TileEntityBulkConveyor;
import cassiokf.industrialrenewal.tileentity.TileEntityBulkConveyorHopper;
import cassiokf.industrialrenewal.tileentity.TileEntityBulkConveyorInserter;
import cassiokf.industrialrenewal.util.enums.EnumBulkConveyorType;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBulkConveyor
extends BlockHorizontalFacing {
    public static final PropertyInteger MODE = PropertyInteger.func_177719_a((String)"mode", (int)0, (int)2);
    public static final PropertyBool FRONT = PropertyBool.func_177716_a((String)"front");
    public static final PropertyBool BACK = PropertyBool.func_177716_a((String)"back");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    public final EnumBulkConveyorType type;

    public BlockBulkConveyor(String name, CreativeTabs tab, EnumBulkConveyorType type) {
        super(name, tab, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.type = type;
    }

    public static double getMotionX(EnumFacing facing) {
        return facing == EnumFacing.EAST ? 0.2 : -0.2;
    }

    public static double getMotionZ(EnumFacing facing) {
        return facing == EnumFacing.SOUTH ? 0.2 : -0.2;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (this.type.equals((Object)EnumBulkConveyorType.NORMAL) && entityIn instanceof EntityLivingBase) {
            EnumFacing facing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                entityIn.field_70179_y += BlockBulkConveyor.getMotionZ(facing);
            } else {
                entityIn.field_70159_w += BlockBulkConveyor.getMotionX(facing);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (this.type.equals((Object)EnumBulkConveyorType.NORMAL)) {
                if (heldItem.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150438_bZ))) {
                    EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    worldIn.func_180501_a(pos, ModBlocks.conveyorVHopper.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing1), 3);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!playerIn.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
                if (heldItem.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150367_z))) {
                    EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    worldIn.func_180501_a(pos, ModBlocks.conveyorVInserter.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing1), 3);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!playerIn.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
            } else if (heldItem.func_77973_b().equals((Object)ModItems.screwDrive)) {
                if (this.type.equals((Object)EnumBulkConveyorType.HOPPER)) {
                    EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    worldIn.func_180501_a(pos, ModBlocks.conveyorV.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing1), 3);
                    ItemPowerScrewDrive.playDrillSound(worldIn, pos);
                    return true;
                }
                if (this.type.equals((Object)EnumBulkConveyorType.INSERTER)) {
                    EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    worldIn.func_180501_a(pos, ModBlocks.conveyorV.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing1), 3);
                    ItemPowerScrewDrive.playDrillSound(worldIn, pos);
                    return true;
                }
            } else if (Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockBulkConveyor) {
                IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
                EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
                int mode = (Integer)actualState.func_177229_b((IProperty)MODE);
                if (mode == 2 && worldIn.func_180495_p(pos.func_177972_a(face).func_177977_b()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos.func_177972_a(face).func_177977_b(), state, 3);
                        if (!playerIn.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos.func_177972_a(face), state, 3);
                        if (!playerIn.func_184812_l_()) {
                            heldItem.func_190918_g(1);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityBulkConveyor) {
            ((TileEntityBulkConveyor)tileentity).dropInventory();
            worldIn.func_175666_e(pos, (Block)this);
        }
        if (!this.type.equals((Object)EnumBulkConveyorType.NORMAL)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            ItemStack itemst = this.type.equals((Object)EnumBulkConveyorType.HOPPER) ? new ItemStack(Item.func_150898_a((Block)Blocks.field_150438_bZ)) : new ItemStack(Item.func_150898_a((Block)Blocks.field_150367_z));
            EntityItem entity = new EntityItem(worldIn, (double)x, (double)y, (double)z, itemst);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)entity);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random par2Random, int par3) {
        return new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.conveyorV)).func_77973_b();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MODE, FRONT, BACK});
    }

    private int getMode(IBlockAccess world, BlockPos pos, IBlockState ownState) {
        if (this.type != EnumBulkConveyorType.NORMAL) {
            return 0;
        }
        EnumFacing facing = (EnumFacing)ownState.func_177229_b((IProperty)FACING);
        IBlockState frontState = world.func_180495_p(pos.func_177972_a(facing));
        IBlockState upState = world.func_180495_p(pos.func_177972_a(facing).func_177984_a());
        IBlockState directUpState = world.func_180495_p(pos.func_177984_a());
        IBlockState downState = world.func_180495_p(pos.func_177972_a(facing).func_177977_b());
        IBlockState backUpState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()).func_177984_a());
        IBlockState backState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (!(!(upState.func_177230_c() instanceof BlockBulkConveyor) || !((EnumFacing)upState.func_177229_b((IProperty)FACING)).equals((Object)facing) || directUpState.func_177230_c() instanceof BlockBulkConveyor || frontState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)frontState.func_177229_b((IProperty)FACING)).equals((Object)facing))) {
            return 1;
        }
        if (downState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)downState.func_177229_b((IProperty)FACING)).equals((Object)facing) && backUpState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)backUpState.func_177229_b((IProperty)FACING)).equals((Object)facing) || (!(backState.func_177230_c() instanceof BlockBulkConveyor) || !((EnumFacing)backState.func_177229_b((IProperty)FACING)).equals((Object)facing)) && backUpState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)backUpState.func_177229_b((IProperty)FACING)).equals((Object)facing)) {
            return 2;
        }
        return 0;
    }

    private boolean getFront(IBlockAccess world, BlockPos pos, IBlockState ownState, int mode) {
        if (this.type.equals((Object)EnumBulkConveyorType.INSERTER)) {
            return false;
        }
        EnumFacing facing = (EnumFacing)ownState.func_177229_b((IProperty)FACING);
        IBlockState frontState = world.func_180495_p(pos.func_177972_a((EnumFacing)ownState.func_177229_b((IProperty)FACING)));
        IBlockState downState = world.func_180495_p(pos.func_177972_a(facing).func_177977_b());
        if (mode == 0) {
            return !(frontState.func_177230_c() instanceof BlockBulkConveyor) || (!(frontState.func_177230_c() instanceof BlockBulkConveyor) || !((EnumFacing)frontState.func_177229_b((IProperty)FACING)).equals((Object)facing)) && downState.func_177230_c() instanceof BlockBulkConveyor;
        }
        if (mode == 1) {
            return false;
        }
        if (mode == 2) {
            return !(frontState.func_177230_c() instanceof BlockBulkConveyor) && !(downState.func_177230_c() instanceof BlockBulkConveyor);
        }
        return false;
    }

    private boolean getBack(IBlockAccess world, BlockPos pos, IBlockState ownState, int mode) {
        EnumFacing facing = (EnumFacing)ownState.func_177229_b((IProperty)FACING);
        IBlockState backState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        IBlockState downState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()).func_177977_b());
        if (mode == 0) {
            return !(backState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)backState.func_177229_b((IProperty)FACING)).equals((Object)facing) || downState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)downState.func_177229_b((IProperty)FACING)).equals((Object)facing));
        }
        if (mode == 1) {
            return !(downState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)downState.func_177229_b((IProperty)FACING)).equals((Object)facing) || backState.func_177230_c() instanceof BlockBulkConveyor && ((EnumFacing)backState.func_177229_b((IProperty)FACING)).equals((Object)facing));
        }
        if (mode == 2) {
            return false;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int mode = this.getMode(worldIn, pos, state);
        boolean front = this.getFront(worldIn, pos, state, mode);
        boolean back = this.getBack(worldIn, pos, state, mode);
        return state.func_177226_a((IProperty)MODE, (Comparable)Integer.valueOf(mode)).func_177226_a((IProperty)FRONT, (Comparable)Boolean.valueOf(front)).func_177226_a((IProperty)BACK, (Comparable)Boolean.valueOf(back));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBulkConveyor && super.rotateBlock(world, pos, axis)) {
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
            ((TileEntityBulkConveyor)te).setFacing(facing);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.type == EnumBulkConveyorType.NORMAL) {
            return BLOCK_AABB;
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        boolean ramp;
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        EnumFacing face = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        int mode = (Integer)actualState.func_177229_b((IProperty)MODE);
        boolean bl = ramp = mode == 1 || mode == 2;
        if (this.type == EnumBulkConveyorType.NORMAL) {
            BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
            if (ramp) {
                if (face == EnumFacing.NORTH) {
                    BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                }
                if (face == EnumFacing.SOUTH) {
                    BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                }
                if (face == EnumFacing.WEST) {
                    BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
                }
                if (face == EnumFacing.EAST) {
                    BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
                }
            }
        } else {
            BlockBulkConveyor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.conveyorV));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.type == EnumBulkConveyorType.NORMAL) {
            return new TileEntityBulkConveyor();
        }
        if (this.type == EnumBulkConveyorType.HOPPER) {
            return new TileEntityBulkConveyorHopper();
        }
        return new TileEntityBulkConveyorInserter();
    }
}

