/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.utils;

import java.util.Random;
import javax.annotation.Nullable;
import me.swirtzly.angels.common.entities.EntityAnomaly;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.AngelUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public final class Teleporter {
    @Nullable
    public static Entity move(Entity entity, int dimension, BlockPos pos) {
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        return Teleporter.move(entity, dimension, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    @Nullable
    public static Entity move(Entity entity, int dimension, double x, double y, double z) {
        if (entity.field_70170_p.field_72995_K || !entity.func_184222_aU()) {
            return null;
        }
        if (entity.field_71093_bK == dimension) {
            if (entity instanceof EntityPlayerMP) {
                if (((EntityPlayerMP)entity).field_71135_a != null) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
                }
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
            return entity;
        }
        return entity.changeDimension(dimension, (ITeleporter)new WATeleport(x, y, z));
    }

    public static Entity moveSafeAcrossDim(Entity entity, BlockPos pos) {
        EntityAnomaly anomaly = new EntityAnomaly(entity.field_70170_p);
        BlockPos entityOldPos = entity.func_180425_c();
        anomaly.func_70012_b(entityOldPos.func_177958_n(), entityOldPos.func_177956_o(), entityOldPos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
        entity.field_70170_p.func_72838_d((Entity)anomaly);
        if (entity instanceof EntityPlayerMP) {
            BlockPos spawn;
            DimensionType newDimension = Teleporter.getRandomDimension(entity, entity.field_70170_p.field_73012_v);
            if (newDimension != entity.field_70170_p.field_73011_w.func_186058_p()) {
                entity.changeDimension(newDimension.func_186068_a(), (world, en, yaw) -> entity.func_70012_b(0.0, 0.0, 0.0, en.field_70177_z, en.field_70125_A));
            }
            World world2 = entity.func_130014_f_();
            boolean beSafeFlag = newDimension == DimensionType.THE_END || newDimension == DimensionType.NETHER;
            BlockPos blockPos = spawn = beSafeFlag ? pos : world2.func_175694_M();
            while (!(world2.func_175623_d(spawn) && world2.func_175623_d(spawn.func_177984_a()) || spawn.func_177956_o() >= world2.field_73011_w.getHeight() - 5)) {
                spawn = spawn.func_177984_a();
            }
            entity.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
            return entity;
        }
        return entity;
    }

    public static DimensionType getRandomDimension(Entity angel, Random rand) {
        DimensionType dim = Teleporter.randomEnum(DimensionType.class, rand);
        if (dim == null || !WAConfig.teleport.angelDimTeleport) {
            return angel.field_70170_p.field_73011_w.func_186058_p();
        }
        for (int notAllowedDimension : WAConfig.teleport.notAllowedDimensions) {
            if (notAllowedDimension != dim.func_186068_a()) continue;
            return DimensionType.OVERWORLD;
        }
        return dim;
    }

    public static void handleStructures(EntityPlayer player) {
        BlockPos bPos;
        String[] targetStructure = null;
        switch (player.field_70170_p.field_73011_w.getDimension()) {
            case 0: {
                targetStructure = AngelUtils.OVERWORLD_STRUCTURES;
                break;
            }
            case 1: {
                targetStructure = AngelUtils.END_STRUCTURES;
                break;
            }
            case -1: {
                targetStructure = AngelUtils.NETHER_STRUCTURES;
            }
        }
        if (targetStructure != null && (bPos = player.func_130014_f_().func_190528_a(targetStructure[player.field_70170_p.field_73012_v.nextInt(targetStructure.length)], player.func_180425_c(), false)) != null) {
            Teleporter.move((Entity)player, player.field_71093_bK, bPos);
        }
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz, Random random) {
        int x = random.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static final class WATeleport
    implements ITeleporter {
        private final double x;
        private final double y;
        private final double z;

        public WATeleport(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_70012_b(this.x, this.y, this.z, yaw, entity.field_70125_A);
        }
    }
}

