/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import me.swirtzly.angels.common.WAObjects;
import me.swirtzly.angels.common.entities.AngelEnums;
import me.swirtzly.angels.common.entities.EntityQuantumLockBase;
import me.swirtzly.angels.common.entities.EntityWeepingAngel;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AngelUtils {
    private static final Random RANDOM = new Random(23435325L);
    public static String[] END_STRUCTURES = new String[]{"EndCity"};
    public static String[] OVERWORLD_STRUCTURES = new String[]{"Stronghold", "Monument", "Village", "Mansion", "Temple", "Mineshaft"};
    public static String[] NETHER_STRUCTURES = new String[]{"Fortress"};
    public static ArrayList<Item> LIGHT_ITEMS = new ArrayList();

    public static void playBreakEvent(Entity entity, BlockPos pos, Block block) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_184185_a(WAObjects.Sounds.LIGHT_BREAK, 1.0f, 1.0f);
            InventoryHelper.func_180173_a((World)entity.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(entity.field_70170_p.func_180495_p(pos).func_177230_c()));
            entity.field_70170_p.func_175656_a(pos, block.func_176223_P());
            for (EntityPlayer player : entity.field_70170_p.field_73010_i) {
                EntityPlayerMP playerMP;
                if (!(player instanceof EntityPlayerMP) || !((playerMP = (EntityPlayerMP)player).func_174818_b(pos) < 45.0)) continue;
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketParticles(EnumParticleTypes.CRIT_MAGIC, false, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), 0.0f, 0.0f, 0.0f, 1.0f, 11, new int[0]));
            }
        }
    }

    public static boolean isDarkForPlayer(EntityQuantumLockBase angel, EntityLivingBase living) {
        return !living.func_70644_a(MobEffects.field_76439_r) && angel.field_70170_p.func_175699_k(angel.func_180425_c()) <= 0 && angel.field_70170_p.field_73011_w.func_191066_m() && !AngelUtils.handLightCheck(living) || living.func_70644_a(MobEffects.field_76440_q);
    }

    public static void setupLightItems() {
        ForgeRegistries.BLOCKS.getValuesCollection().forEach(block -> {
            if (AngelUtils.getLightValue(block) > 7) {
                LIGHT_ITEMS.add(Item.func_150898_a((Block)block));
            }
        });
        LIGHT_ITEMS.add(Item.func_150898_a((Block)Blocks.field_150429_aA));
        LIGHT_ITEMS.add(Item.func_150898_a((Block)Blocks.field_150478_aa));
        LIGHT_ITEMS.removeIf(item -> item == Items.field_190931_a);
    }

    public static boolean handLightCheck(EntityLivingBase player) {
        for (Item item : LIGHT_ITEMS) {
            if (!PlayerUtils.isInEitherHand(player, item)) continue;
            return true;
        }
        return false;
    }

    public static void setUpSpawns() {
        ArrayList SPAWNS = Lists.newArrayList();
        SPAWNS.addAll(ForgeRegistries.BIOMES.getValuesCollection());
        for (String rs : WAConfig.spawn.notAllowedBiomes) {
            if (!Biome.field_185377_q.func_148741_d((Object)new ResourceLocation(rs))) continue;
            Biome removedBiome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(rs));
            SPAWNS.remove(removedBiome);
        }
        for (Biome spawn : SPAWNS) {
            if (spawn == null) continue;
            EntityRegistry.addSpawn(EntityWeepingAngel.class, (int)WAConfig.spawn.spawnProbability, (int)WAConfig.spawn.minimumSpawn, (int)WAConfig.spawn.maximumSpawn, (EnumCreatureType)WAConfig.spawn.spawnType, (Biome[])new Biome[]{spawn});
        }
    }

    public static int secondsToTicks(int seconds) {
        return 20 * seconds;
    }

    public static void removeLightFromHand(EntityPlayerMP playerMP, EntityWeepingAngel angel) {
        if (playerMP.func_70068_e((Entity)angel) < 1.0) {
            for (EnumHand enumHand : EnumHand.values()) {
                ItemStack stack = playerMP.func_184586_b(enumHand);
                if (!AngelUtils.lightCheck(stack, angel)) continue;
                stack.func_190918_g(1);
                angel.func_184185_a(WAObjects.Sounds.BLOW, 1.0f, 1.0f);
                return;
            }
        }
    }

    public static int getLightValue(Block block) {
        return (Integer)ReflectionHelper.getPrivateValue(Block.class, (Object)block, (int)9);
    }

    private static boolean lightCheck(ItemStack stack, EntityWeepingAngel angel) {
        if (LIGHT_ITEMS.contains(stack.func_77973_b())) {
            stack.func_190918_g(1);
            angel.func_145779_a(stack.func_77973_b(), 1);
            return true;
        }
        return false;
    }

    public static AngelEnums.AngelType randomType() {
        int pick = new Random().nextInt(AngelEnums.AngelType.values().length);
        return AngelEnums.AngelType.values()[pick];
    }

    public static boolean isPosOutsideBorder(BlockPos pos, World world) {
        double d0 = world.func_175723_af().func_177726_b();
        double d1 = world.func_175723_af().func_177736_c();
        double d2 = world.func_175723_af().func_177728_d();
        double d3 = world.func_175723_af().func_177733_e();
        return (double)pos.func_177958_n() > (d0 -= 1.0) && (double)pos.func_177958_n() < (d2 += 1.0) && (double)pos.func_177952_p() > (d1 -= 1.0) && (double)pos.func_177952_p() < (d3 += 1.0);
    }

    public static double randomBetween(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static enum EnumTeleportType {
        STRUCTURES,
        RANDOM_PLACE,
        DONT;

    }
}

