/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.compat.vivecraft;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import me.swirtzly.angels.WeepingAngels;
import me.swirtzly.angels.compat.vivecraft.VivecraftReflector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class ServerReflector
extends VivecraftReflector {
    public int enabled = -1;
    private Field fVivePlayers;
    private Method mGetHMDDir;
    private Method mGetHMDPos;
    private Method isVR;
    private Constructor<?> conQuaternion;
    private Field fHead;
    private Field fController0;
    private Field fController1;
    private Field fSeated;
    private Field fWorldScale;
    private Field fPosX;
    private Field fPosY;
    private Field fPosZ;
    private Field fRotW;
    private Field fRotX;
    private Field fRotY;
    private Field fRotZ;
    private Method mGetPlayerData;
    private Method mHasPlayerData;
    private Method mVecMultiply;

    @Override
    public boolean init() {
        this.enabled = 0;
        WeepingAngels.LOGGER.info("Checking for Vivecraft Client...");
        try {
            Class<?> cNetworkHelper = Class.forName("org.vivecraft.api.NetworkHelper");
            Class<?> cVivePlayer = Class.forName("org.vivecraft.api.VivePlayer");
            this.fVivePlayers = cNetworkHelper.getDeclaredField("vivePlayers");
            this.mGetHMDDir = cVivePlayer.getDeclaredMethod("getHMDDir", new Class[0]);
            this.mGetHMDPos = cVivePlayer.getDeclaredMethod("getHMDPos", new Class[0]);
            this.isVR = cVivePlayer.getMethod("isVR", new Class[0]);
            WeepingAngels.LOGGER.info("Vivecraft Client detected! Enabling compatibility features.");
        }
        catch (Exception e) {
            this.enabled = -1;
        }
        if (this.enabled < 0) {
            this.enabled = 1;
            try {
                Class<?> cVRPlayerData = Class.forName("com.techjar.vivecraftforge.util.VRPlayerData");
                Class<?> cObjectInfo = Class.forName("com.techjar.vivecraftforge.util.VRPlayerData$ObjectInfo");
                this.fHead = cVRPlayerData.getDeclaredField("head");
                this.fController0 = cVRPlayerData.getDeclaredField("controller0");
                this.fController1 = cVRPlayerData.getDeclaredField("controller1");
                this.fSeated = cVRPlayerData.getDeclaredField("seated");
                this.fWorldScale = cVRPlayerData.getDeclaredField("worldScale");
                this.fPosX = cObjectInfo.getDeclaredField("posX");
                this.fPosY = cObjectInfo.getDeclaredField("posY");
                this.fPosZ = cObjectInfo.getDeclaredField("posZ");
                this.fRotW = cObjectInfo.getDeclaredField("rotW");
                this.fRotX = cObjectInfo.getDeclaredField("rotX");
                this.fRotY = cObjectInfo.getDeclaredField("rotY");
                this.fRotZ = cObjectInfo.getDeclaredField("rotZ");
                Class<?> cPlayerTracker = Class.forName("com.techjar.vivecraftforge.util.PlayerTracker");
                this.mGetPlayerData = cPlayerTracker.getMethod("getPlayerData", EntityPlayer.class);
                this.mHasPlayerData = cPlayerTracker.getMethod("hasPlayerData", EntityPlayer.class);
                Class<?> cQuaternion = Class.forName("com.techjar.vivecraftforge.util.Quaternion");
                this.conQuaternion = cQuaternion.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
                this.mVecMultiply = cQuaternion.getMethod("multiply", Vec3d.class);
                WeepingAngels.LOGGER.info("Vivecraft Forge Extensions detected! Enabling compatability features.");
            }
            catch (Exception e) {
                this.enabled = -1;
            }
        }
        if (this.enabled < 0) {
            WeepingAngels.LOGGER.info("Vivecraft not detected!");
        }
        return this.enabled >= 0;
    }

    @Override
    public boolean isVRPlayer(EntityPlayer player) {
        if (this.enabled < 0) {
            return false;
        }
        try {
            UUID uuid = player.func_110124_au();
            if (this.enabled == 0) {
                Map vivePlayers = (Map)this.fVivePlayers.get(null);
                if (vivePlayers.containsKey(uuid)) {
                    Object vivePlayer = vivePlayers.get(uuid);
                    return (Boolean)this.isVR.invoke(vivePlayer, new Object[0]);
                }
            } else if (this.enabled == 1) {
                return (Boolean)this.mHasPlayerData.invoke(null, player);
            }
        }
        catch (Exception e) {
            WeepingAngels.LOGGER.warn("Vivecraft Server: Unknown Error Parsing isVRPlayer", (Throwable)e);
        }
        return false;
    }

    @Override
    public Vec3d getHMDPos(EntityPlayer player) {
        try {
            if (this.enabled == 0) {
                UUID uuid = player.func_110124_au();
                Map vivePlayers = (Map)this.fVivePlayers.get(null);
                Object vivePlayer = vivePlayers.get(uuid);
                return (Vec3d)this.mGetHMDPos.invoke(vivePlayer, new Object[0]);
            }
            if (this.enabled == 1) {
                Object playerHead = this.fHead.get(this.mGetPlayerData.invoke(null, player));
                float X = this.fPosX.getFloat(playerHead);
                float Y = this.fPosY.getFloat(playerHead);
                float Z = this.fPosZ.getFloat(playerHead);
                return new Vec3d((double)X, (double)Y, (double)Z);
            }
        }
        catch (Exception e) {
            WeepingAngels.LOGGER.warn("Vivecraft Server: Unknown Error Parsing getHMDPos", (Throwable)e);
        }
        return player.func_174791_d().func_72441_c(0.0, 1.62, 0.0);
    }

    @Override
    public Vec3d getHMDRot(EntityPlayer player) {
        try {
            UUID uuid = player.func_110124_au();
            if (this.enabled == 0) {
                Map vivePlayers = (Map)this.fVivePlayers.get(null);
                Object vivePlayer = vivePlayers.get(uuid);
                return (Vec3d)this.mGetHMDDir.invoke(vivePlayer, new Object[0]);
            }
            if (this.enabled == 1) {
                Object playerHead = this.fHead.get(this.mGetPlayerData.invoke(null, player));
                float W = this.fRotW.getFloat(playerHead);
                float X = this.fRotX.getFloat(playerHead);
                float Y = this.fRotY.getFloat(playerHead);
                float Z = this.fRotZ.getFloat(playerHead);
                Object quaternion = this.conQuaternion.newInstance(Float.valueOf(W), Float.valueOf(X), Float.valueOf(Y), Float.valueOf(Z));
                return (Vec3d)this.mVecMultiply.invoke(quaternion, new Vec3d(0.0, 0.0, -1.0));
            }
        }
        catch (Exception e) {
            WeepingAngels.LOGGER.warn("Vivecraft Server: Unknown Error Parsing getHMDRot", (Throwable)e);
        }
        return player.func_70040_Z();
    }
}

