/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common.events;

import java.util.Random;
import me.swirtzly.angels.WeepingAngels;
import me.swirtzly.angels.common.WAObjects;
import me.swirtzly.angels.common.entities.EntityWeepingAngel;
import me.swirtzly.angels.config.WAConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="weeping-angels")
public class EventHandler {
    private static WorldGenMinable genCrystal = new WorldGenMinable(WAObjects.Blocks.KONTRON_ORE.func_176223_P(), 3);

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        if (!player.field_70170_p.field_72995_K && WAConfig.angels.enableUpdateChecker) {
            ForgeVersion.CheckResult version = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
            if (version.status.equals((Object)ForgeVersion.Status.OUTDATED)) {
                TextComponentString url = new TextComponentString(TextFormatting.AQUA + TextFormatting.BOLD.toString() + "UPDATE");
                url.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/weeping-angels-mod"));
                url.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Open URL")));
                player.func_145747_a(new TextComponentString(TextFormatting.GOLD + "[Weeping Angels] : ").func_150257_a((ITextComponent)url));
                String changes = (String)version.changes.get(version.target);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Changes: " + TextFormatting.BLUE + changes));
            }
        }
    }

    @SubscribeEvent
    public static void onBiomeDecorated(DecorateBiomeEvent.Pre e) {
        World world = e.getWorld();
        Random rand = e.getRand();
        if (world.func_180494_b(e.getPos()).func_150559_j() && rand.nextInt(5) <= 3) {
            EventHandler.generateArms(world, e.getPos());
        }
        if (!WAConfig.worldGen.genOres) {
            return;
        }
        int blockY = rand.nextInt(64);
        int blockX = e.getChunkPos().field_77276_a * 16 + (rand.nextInt(16) + 8);
        int blockZ = e.getChunkPos().field_77275_b * 16 + (rand.nextInt(16) + 8);
        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
        if (world.field_73011_w.getDimension() == 0 && rand.nextBoolean() && !world.func_180494_b(e.getPos()).func_150559_j() && blockY > 3 && blockY < 60) {
            genCrystal.func_180709_b(world, rand, pos);
        }
    }

    private static void generateArms(World world, BlockPos position) {
        if (!WAConfig.worldGen.arms) {
            return;
        }
        BlockPos pos = new BlockPos((Vec3i)position.func_177971_a((Vec3i)new BlockPos(8, 0, 8)));
        if (!(world.field_73011_w.func_177495_o() && pos.func_177956_o() >= 255 || !world.func_180494_b(position).func_150559_j() || world.func_180495_p(pos).func_177230_c() != Blocks.field_150433_aE && world.func_180495_p(pos).func_177230_c() != Blocks.field_150431_aC)) {
            world.func_180501_a(pos, WAObjects.Blocks.ARM.func_176223_P(), 1);
        }
    }

    @SubscribeEvent
    public static void cancelDamage(LivingAttackEvent e) {
        Entity source = e.getSource().func_76346_g();
        DamageSource dSource = e.getSource();
        if (source instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source;
            EntityLivingBase victim = e.getEntityLiving();
            if (victim instanceof EntityWeepingAngel) {
                EntityPlayer player;
                if (WAConfig.angels.hardcoreMode) {
                    e.setCanceled(true);
                    return;
                }
                if (!WAConfig.angels.pickaxeOnly) {
                    return;
                }
                ItemStack item = attacker.func_184582_a(EntityEquipmentSlot.MAINHAND);
                boolean isPic = item.func_77973_b() instanceof ItemPickaxe || item.func_77973_b().getRegistryName().toString().contains("pickaxe") || item.func_150998_b(Blocks.field_150343_Z.func_176223_P());
                Item pick = item.func_77973_b();
                if (attacker instanceof EntityPlayer && !(player = (EntityPlayer)attacker).func_184811_cZ().func_185141_a(pick) && WAConfig.angels.pickaxeCooldown) {
                    player.func_184811_cZ().func_185145_a(pick, WAConfig.angels.pickaxeCooldownTicks);
                }
                e.setCanceled(!isPic);
                if (!isPic && !dSource.func_76352_a()) {
                    attacker.func_70097_a(WAObjects.STONE, 2.0f);
                    victim.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                } else if (pick != Items.field_151046_w && victim.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    e.setCanceled(true);
                } else if (!(source instanceof Entity)) {
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootTablesLoaded(LootTableLoadEvent event) {
        LootPool pool2;
        if (event.getName().func_110624_b().contains("chests") && (pool2 = event.getTable().getPool("pool2")) != null) {
            pool2.addEntry((LootEntry)new LootEntryItem(WAObjects.Items.CHRONODYNE_GENERATOR, 10, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "weeping-angels:generators"));
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.CheckSpawn e) {
        if (e.getEntity() instanceof EntityWeepingAngel) {
            e.setResult(Event.Result.DENY);
            for (int i : WAConfig.spawn.dimensionWhitelist) {
                if (i != e.getWorld().field_73011_w.getDimension()) continue;
                e.setResult(Event.Result.DEFAULT);
            }
        }
    }

    @SubscribeEvent
    public static void onMissingMappingItem(RegistryEvent.MissingMappings<Item> e) {
        for (RegistryEvent.MissingMappings.Mapping map : e.getAllMappings()) {
            if (!map.key.toString().equals("weeping-angels:unlit_torch")) continue;
            WeepingAngels.LOGGER.warn("This world contains a removed item, removing: " + map.key);
            map.ignore();
        }
    }
}

