/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.common.entities;

import java.util.List;
import me.swirtzly.angels.config.WAConfig;
import me.swirtzly.angels.utils.AngelUtils;
import me.swirtzly.angels.utils.ViewUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityQuantumLockBase
extends EntityMob {
    private static final DataParameter<Boolean> IS_SEEN = EntityDataManager.func_187226_a(EntityQuantumLockBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIME_VIEWED = EntityDataManager.func_187226_a(EntityQuantumLockBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> PREVBLOCKPOS = EntityDataManager.func_187226_a(EntityQuantumLockBase.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> QUANTUM = EntityDataManager.func_187226_a(EntityQuantumLockBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityQuantumLockBase(World worldIn) {
        super(worldIn);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 4 == 0) {
            this.setQuantum(this.quantumCheck());
        }
        super.func_70636_d();
        if (!this.isQuantumLocked() || WAConfig.angels.freezeOnAngel) {
            this.field_70759_as = this.field_70177_z;
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g((double)WAConfig.angels.stalkRange));
                players.removeIf(player -> player.func_175149_v() || player.func_82150_aj() || player.func_70608_bn());
                if (players.isEmpty()) {
                    this.setSeenTime(0);
                    return;
                }
                EntityPlayer targetPlayer = null;
                for (EntityPlayer player2 : players) {
                    if (ViewUtil.isInSight((EntityLivingBase)player2, this) && !AngelUtils.isDarkForPlayer(this, (EntityLivingBase)player2)) {
                        this.setSeenTime(this.getSeenTime() + 1);
                        this.invokeSeen(player2);
                        return;
                    }
                    if (targetPlayer != null) continue;
                    targetPlayer = player2;
                    this.setSeenTime(0);
                }
                Vec3d vecPos = this.func_174791_d();
                Vec3d vecPlayerPos = targetPlayer.func_174791_d();
                float angle = (float)Math.toDegrees((float)Math.atan2(vecPos.field_72449_c - vecPlayerPos.field_72449_c, vecPos.field_72450_a - vecPlayerPos.field_72450_a));
                this.field_70177_z = angle > 180.0f ? angle : angle + 90.0f;
                this.field_70759_as = this.field_70177_z;
                if (this.isSeen()) {
                    return;
                }
                if (this.func_70032_d((Entity)targetPlayer) < 2.0f) {
                    this.func_70652_k((Entity)targetPlayer);
                } else {
                    this.moveTowards((EntityLivingBase)targetPlayer);
                }
            }
        }
    }

    public void moveTowards(EntityLivingBase targetPlayer) {
        this.func_70661_as().func_75497_a((Entity)targetPlayer, WAConfig.angels.moveSpeed);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SEEN, (Object)false);
        this.func_184212_Q().func_187214_a(TIME_VIEWED, (Object)0);
        this.func_184212_Q().func_187214_a(PREVBLOCKPOS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(QUANTUM, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isSeen", this.isSeen());
        compound.func_74768_a("timeSeen", this.getSeenTime());
        compound.func_74772_a("prevPos", this.getPrevPos().func_177986_g());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("timeSeen")) {
            this.setSeenTime(compound.func_74762_e("timeSeen"));
        }
        if (compound.func_74764_b("prevPos")) {
            this.setPrevPos(this.getPrevPos());
        }
        if (compound.func_74764_b("isSeen")) {
            this.setQuantum(compound.func_74767_n("isSeen"));
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        super.func_180431_b(source);
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && trueSource instanceof EntityPlayer) {
            return false;
        }
        return !source.equals(DamageSource.field_76366_f);
    }

    public boolean isSeen() {
        return this.getSeenTime() > 0;
    }

    public int getSeenTime() {
        return (Integer)this.func_184212_Q().func_187225_a(TIME_VIEWED);
    }

    public void setSeenTime(int time) {
        this.func_184212_Q().func_187227_b(TIME_VIEWED, (Object)time);
    }

    public BlockPos getPrevPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(PREVBLOCKPOS);
    }

    public void setPrevPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(PREVBLOCKPOS, (Object)pos);
    }

    public boolean isQuantumLocked() {
        return (Boolean)this.func_184212_Q().func_187225_a(QUANTUM);
    }

    public void setQuantum(boolean locked) {
        this.func_184212_Q().func_187227_b(QUANTUM, (Object)locked);
    }

    public void invokeSeen(EntityPlayer player) {
        this.func_94061_f(true);
        this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
        this.func_70661_as().func_75484_a(null, 0.0);
    }

    private boolean quantumCheck() {
        if (WAConfig.angels.freezeOnAngel) {
            List quantumLockBases = this.field_70170_p.func_72872_a(EntityQuantumLockBase.class, this.func_174813_aQ().func_186662_g(25.0));
            boolean flag = quantumLockBases.isEmpty();
            if (flag) {
                this.setSeenTime(0);
            } else {
                for (EntityQuantumLockBase base : quantumLockBases) {
                    if (base.func_110124_au() == this.func_110124_au() || !this.field_70170_p.func_175667_e(this.func_180425_c()) || !(base.func_70032_d((Entity)this) < 25.0f) || !ViewUtil.canEntitySee((EntityLivingBase)base, (EntityLivingBase)this)) continue;
                    return true;
                }
            }
        } else {
            this.setQuantum(false);
            return false;
        }
        return false;
    }
}

