/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.angels.client.models.poses;

import java.util.Random;

public class PoseManager {
    private static Random RANDOM = new Random();

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        int x = RANDOM.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public static AngelPoses getPoseFromString(String poseName) {
        for (AngelPoses pose : AngelPoses.values()) {
            if (!pose.name().equalsIgnoreCase(poseName)) continue;
            return pose;
        }
        return AngelPoses.HIDING_FACE;
    }

    public static enum AngelPoses {
        ANGRY(true),
        ANGRY_TWO(true),
        SHY,
        HIDING_FACE,
        OPEN_ARMS,
        IDLE,
        HIDING_FACE_ANGRY(true);

        private final boolean angryFace;

        private AngelPoses(boolean hasAngryFace) {
            this.angryFace = hasAngryFace;
        }

        private AngelPoses() {
            this.angryFace = false;
        }

        public boolean hasAngryFace() {
            return this.angryFace;
        }
    }
}

