/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.pathos.api.event;

import java.util.function.BiFunction;
import ladysnake.pathos.api.ISicknessHandler;
import ladysnake.pathos.api.SicknessEffect;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class SicknessEvent
extends LivingEvent {
    protected final ISicknessHandler sicknessHandler;
    protected final SicknessEffect effect;

    public SicknessEvent(ISicknessHandler sicknessHandler, EntityLivingBase entity, SicknessEffect effect) {
        super(entity);
        this.sicknessHandler = sicknessHandler;
        this.effect = effect;
    }

    public SicknessEffect getEffect() {
        return this.effect;
    }

    @Cancelable
    public static class SicknessCureEvent
    extends SicknessEvent {
        public SicknessCureEvent(ISicknessHandler sicknessHandler, EntityLivingBase entity, SicknessEffect effect) {
            super(sicknessHandler, entity, effect);
        }
    }

    public static class SicknessTickEvent
    extends SicknessEvent {
        public SicknessTickEvent(ISicknessHandler sicknessHandler, EntityLivingBase entity, SicknessEffect effect) {
            super(sicknessHandler, entity, effect);
        }
    }

    @Cancelable
    public static class SicknessAddEvent
    extends SicknessEvent {
        private BiFunction<SicknessEffect, SicknessEffect, SicknessEffect> mergeFunction;

        public SicknessAddEvent(ISicknessHandler sicknessHandler, EntityLivingBase entity, SicknessEffect effect, BiFunction<SicknessEffect, SicknessEffect, SicknessEffect> mergeFunction) {
            super(sicknessHandler, entity, effect);
            this.mergeFunction = mergeFunction;
        }

        public BiFunction<SicknessEffect, SicknessEffect, SicknessEffect> getMergeFunction() {
            return this.mergeFunction;
        }

        public void setMergeFunction(BiFunction<SicknessEffect, SicknessEffect, SicknessEffect> mergeFunction) {
            this.mergeFunction = mergeFunction;
        }
    }
}

