/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class GasUtil {
    private static final LoadingCache<CacheKey, Integer> distanceCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build(CacheLoader.from(GasUtil::computeDistance));

    public static int getPropagationDistance(World world, BlockPos start, BlockPos goal, int maxPropagationDistance) {
        try {
            return (Integer)distanceCache.get((Object)new CacheKey(world, start, goal, maxPropagationDistance));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int computeDistance(@Nonnull CacheKey dataIn) {
        HashMap<BlockPos, Integer> cost = new HashMap<BlockPos, Integer>();
        cost.put(dataIn.start, 0);
        HashMap<BlockPos, Integer> heuristic = new HashMap<BlockPos, Integer>();
        heuristic.put(dataIn.start, (int)dataIn.start.func_177951_i((Vec3i)dataIn.goal));
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        PriorityQueue<BlockPos> openSet = new PriorityQueue<BlockPos>(Comparator.comparing(heuristic::get));
        openSet.add(dataIn.start);
        while (!openSet.isEmpty()) {
            BlockPos current = (BlockPos)openSet.remove();
            if (current.equals((Object)dataIn.goal)) {
                return (Integer)cost.get(current);
            }
            closedSet.add(current);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                Material mat;
                BlockPos neighbour = current.func_177972_a(facing);
                if (dataIn.start.func_177951_i((Vec3i)neighbour) > (double)dataIn.maxDistanceSq || (mat = dataIn.world.func_180495_p(neighbour).func_185904_a()).func_76220_a() || mat.func_76224_d() || mat.func_76230_c() || closedSet.contains(neighbour)) continue;
                int attemptCost = (Integer)cost.get(current) + 1;
                if (openSet.contains(neighbour) && attemptCost >= cost.getOrDefault(neighbour, Integer.MAX_VALUE)) continue;
                cost.put(neighbour, attemptCost);
                heuristic.put(neighbour, attemptCost * attemptCost + (int)neighbour.func_177951_i((Vec3i)dataIn.goal));
                openSet.add(neighbour);
            }
        }
        return -1;
    }

    public static class CacheKey {
        final World world;
        final BlockPos start;
        final BlockPos goal;
        private int maxDistanceSq;

        public CacheKey(World world, BlockPos start, BlockPos goal, int maxDistance) {
            this.world = world;
            this.start = start;
            this.goal = goal;
            this.maxDistanceSq = maxDistance * maxDistance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.maxDistanceSq != cacheKey.maxDistanceSq) {
                return false;
            }
            if (this.world != null ? !this.world.equals(cacheKey.world) : cacheKey.world != null) {
                return false;
            }
            if (this.start != null ? !this.start.equals((Object)cacheKey.start) : cacheKey.start != null) {
                return false;
            }
            return this.goal != null ? this.goal.equals((Object)cacheKey.goal) : cacheKey.goal == null;
        }

        public int hashCode() {
            int result = this.world != null ? this.world.hashCode() : 0;
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
            result = 31 * result + this.maxDistanceSq;
            return result;
        }
    }
}

