/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import ladylib.misc.ItemUtil;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGrenade;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class ItemGrenadeBelt
extends Item
implements IBauble {
    public static final String NBT_TAG_BELT_STACK = "gaspunk:belt_equipped";

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            player.field_71069_bz.func_75132_a((IContainerListener)new BeltInventoryListener(player));
        }
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            this.updateStackSize((EntityPlayer)player);
        }
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            this.preventTomfoolery((EntityPlayer)player);
        }
    }

    private void updateStackSize(EntityPlayer player) {
        ArrayList inventory = new ArrayList(player.field_71071_by.field_70462_a);
        inventory.addAll(player.field_71071_by.field_184439_c);
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof ItemGrenade)) continue;
            ItemUtil.getOrCreateCompound((ItemStack)stack).func_74757_a(NBT_TAG_BELT_STACK, true);
        }
    }

    private void preventTomfoolery(EntityPlayer player) {
        ArrayList inventory = new ArrayList(player.field_71071_by.field_70462_a);
        inventory.addAll(player.field_71071_by.field_184439_c);
        for (ItemStack stack : inventory) {
            NBTTagCompound nbt;
            if (!(stack.func_77973_b() instanceof ItemGrenade) || (nbt = stack.func_77978_p()) == null) continue;
            nbt.func_82580_o(NBT_TAG_BELT_STACK);
            while (stack.func_190916_E() > 1) {
                ItemStack split = stack.func_77979_a(1);
                if (player.func_191521_c(split)) continue;
                player.func_71019_a(split, false);
            }
        }
    }

    public class BeltInventoryListener
    implements IContainerListener {
        private final EntityPlayerMP owner;

        BeltInventoryListener(EntityPlayerMP owner) {
            this.owner = owner;
        }

        public void func_71111_a(@Nonnull Container containerToSend, int slotInd, @Nonnull ItemStack stack) {
            if (stack.func_77973_b() == ModItems.GRENADE) {
                if (BaublesApi.isBaubleEquipped((EntityPlayer)this.owner, (Item)ModItems.GRENADE_BELT) == -1) {
                    ItemGrenadeBelt.this.preventTomfoolery((EntityPlayer)this.owner);
                } else {
                    ItemGrenadeBelt.this.updateStackSize((EntityPlayer)this.owner);
                }
            }
        }

        public void func_71110_a(@Nonnull Container containerToSend, @Nonnull NonNullList<ItemStack> itemsList) {
        }

        public void func_71112_a(@Nonnull Container containerIn, int varToUpdate, int newValue) {
        }

        public void func_175173_a(@Nonnull Container containerIn, @Nonnull IInventory inventory) {
        }
    }
}

