/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;
import ladysnake.gaspunk.GasPunk;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.init.ModGases;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.item.ItemGasTube;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="gaspunk")
public class GasRecipeDeserializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public static void loadRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContainer gaspunkContainer = Loader.instance().activeModContainer();
        Loader.instance().getActiveModList().forEach(GasRecipeDeserializer::loadRecipes);
        Loader.instance().setActiveModContainer(gaspunkContainer);
        File configFolder = new File(Loader.instance().getConfigDir(), "gaspunk/custom_recipes");
        try {
            if (!configFolder.mkdirs() && configFolder.exists()) {
                JsonContext context = new JsonContext("gaspunk");
                try {
                    Files.walk(configFolder.toPath(), new FileVisitOption[0]).forEach(path -> GasRecipeDeserializer.loadRecipes(configFolder.toPath(), path, context));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (configFolder.exists()) {
                JsonObject recipe = new JsonObject();
                recipe.addProperty("result", "gaspunk:colored_smoke_red");
                JsonObject input = new JsonObject();
                input.addProperty("item", "minecraft:water_bucket");
                recipe.add("input", (JsonElement)input);
                JsonObject ingredient = new JsonObject();
                ingredient.addProperty("type", "forge:ore_dict");
                ingredient.addProperty("ore", "dustRedstone");
                recipe.add("ingredient", (JsonElement)ingredient);
                recipe.addProperty("result", "gaspunk:colored_smoke_red");
                Files.write(configFolder.toPath().resolve("_example.json"), GSON.toJson((JsonElement)recipe).getBytes(), StandardOpenOption.CREATE_NEW);
            }
        }
        catch (IOException e) {
            GasPunk.LOGGER.error("Error while loading gas recipes from config", (Throwable)e);
        }
    }

    private static void loadRecipes(ModContainer container) {
        Loader.instance().setActiveModContainer(container);
        JsonContext context = new JsonContext(container.getModId());
        CraftingHelper.findFiles((ModContainer)container, (String)("assets/" + container.getModId() + "/gaspunk_recipes"), p -> true, (root, file) -> GasRecipeDeserializer.loadRecipes(root, file, context), (boolean)true, (boolean)true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadRecipes(Path root, Path file, JsonContext context) {
        String relative = root.relativize(file).toString();
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return true;
        if (relative.startsWith("_")) {
            return true;
        }
        String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
        ResourceLocation key = new ResourceLocation(context.getModId(), name);
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json == null || json.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)context)) {
                boolean bl = true;
                return bl;
            }
            GasRecipeDeserializer.deserializeRecipe(json, context);
            return true;
        }
        catch (JsonParseException e) {
            GasPunk.LOGGER.error("Parsing error loading recipe {}", (Object)key, (Object)e);
            return false;
        }
        catch (IOException e) {
            GasPunk.LOGGER.error("Couldn't read recipe {} from {}", (Object)key, (Object)file, (Object)e);
            return false;
        }
    }

    private static void deserializeRecipe(JsonObject json, JsonContext context) {
        String resultName = JsonUtils.func_151200_h((JsonObject)json, (String)"result");
        IGas result = (IGas)ModGases.REGISTRY.getValue(new ResourceLocation(resultName));
        if (result == null) {
            throw new JsonParseException("Unrecognized gas: " + resultName);
        }
        JsonObject jsInput = JsonUtils.func_152754_s((JsonObject)json, (String)"input");
        ItemStack in = jsInput.has("gas") ? GasRecipeDeserializer.getBottle((IGas)ModGases.REGISTRY.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsInput, (String)"gas")))) : CraftingHelper.getItemStack((JsonObject)jsInput, (JsonContext)context);
        JsonObject jsIngredient = JsonUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        String type = JsonUtils.func_151219_a((JsonObject)jsIngredient, (String)"type", (String)"minecraft:item");
        if ("forge:ore_dict".equals(type)) {
            String ingredient = JsonUtils.func_151200_h((JsonObject)jsIngredient, (String)"ore");
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new GasBrewingOreRecipe(in, ingredient, ((ItemGasTube)ModItems.GAS_TUBE).getItemStackFor(result)));
        } else if ("minecraft:item".equals(type)) {
            ItemStack ingredient = CraftingHelper.getItemStack((JsonObject)jsIngredient, (JsonContext)context);
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new GasBrewingRecipe(in, ingredient, ((ItemGasTube)ModItems.GAS_TUBE).getItemStackFor(result)));
        }
    }

    public static ItemStack getBottle(IGas prerequisite) {
        if (prerequisite == ModGases.AIR) {
            return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
        }
        return ((ItemGasTube)ModItems.GAS_TUBE).getItemStackFor(prerequisite);
    }

    private static boolean isGasInput(@Nonnull ItemStack stack1, ItemStack stack2) {
        return ItemGasTube.getContainedGas(stack1) == ItemGasTube.getContainedGas(stack2);
    }

    public static class GasBrewingOreRecipe
    extends BrewingOreRecipe {
        public GasBrewingOreRecipe(@Nonnull ItemStack input, @Nonnull String ingredient, @Nonnull ItemStack output) {
            super(input, ingredient, output);
        }

        public boolean isInput(@Nonnull ItemStack stack) {
            return super.isInput(stack) && GasRecipeDeserializer.isGasInput(this.getInput(), stack);
        }
    }

    public static class GasBrewingRecipe
    extends BrewingRecipe {
        public GasBrewingRecipe(@Nonnull ItemStack input, @Nonnull ItemStack ingredient, @Nonnull ItemStack output) {
            super(input, ingredient, output);
        }

        public boolean isInput(@Nonnull ItemStack stack) {
            return super.isInput(stack) && GasRecipeDeserializer.isGasInput(this.getInput(), stack);
        }
    }
}

