/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.gas;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import ladysnake.gaspunk.api.IGas;
import ladysnake.gaspunk.api.IGasAgent;
import ladysnake.gaspunk.api.event.AgentRegistryEvent;
import ladysnake.gaspunk.gas.agent.DamageAgent;
import ladysnake.gaspunk.gas.agent.GasAgent;
import ladysnake.gaspunk.gas.agent.LingeringAgent;
import ladysnake.gaspunk.gas.agent.PotionAgent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="gaspunk")
public class GasAgents {
    private static final BiMap<ResourceLocation, IGasAgent> AGENT_MAP = HashBiMap.create();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRegistryRegister(RegistryEvent.Register<IGas> event) {
        HashMap<ResourceLocation, IGasAgent> registry = new HashMap<ResourceLocation, IGasAgent>();
        MinecraftForge.EVENT_BUS.post((Event)new AgentRegistryEvent(registry));
        registry.forEach((rl, ag) -> {
            if (ag instanceof GasAgent && ag.getUnlocalizedName() == null) {
                ((GasAgent)ag).setUnlocalizedName("agent." + rl.toString().replace(':', '.'));
            }
            AGENT_MAP.put(rl, ag);
        });
    }

    public static IGasAgent createDamageAgent(String name, int maxDamage) {
        DamageAgent ret = GasAgents.name(new DamageAgent(maxDamage), name);
        AGENT_MAP.put((Object)new ResourceLocation("gaspunk", name), (Object)ret);
        return ret;
    }

    public static IGasAgent createPotionAgent(String name, int potionDuration, int potionAmplifier, ResourceLocation potion) {
        PotionAgent ret = GasAgents.name(new PotionAgent(potion, potionDuration, potionAmplifier), "potion");
        AGENT_MAP.put((Object)new ResourceLocation("gaspunk", name), (Object)ret);
        return ret;
    }

    public static IGasAgent createSicknessAgent(String name, boolean toxic, boolean ignoreBreath, ResourceLocation sickness) {
        return GasAgents.createSicknessAgent(name, new LingeringAgent(toxic, ignoreBreath, sickness));
    }

    private static IGasAgent createSicknessAgent(String name, LingeringAgent agent) {
        GasAgents.name(agent, name);
        ResourceLocation id = new ResourceLocation("gaspunk", name);
        AGENT_MAP.put((Object)id, (Object)agent);
        return agent;
    }

    public static <T extends GasAgent> T name(T agent, String name) {
        agent.setUnlocalizedName("agent.gaspunk." + name);
        return agent;
    }

    public static ResourceLocation getId(IGasAgent agent) {
        return (ResourceLocation)AGENT_MAP.inverse().get((Object)agent);
    }

    public static IGasAgent getAgent(ResourceLocation id) {
        return (IGasAgent)AGENT_MAP.get((Object)id);
    }
}

