/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk.api;

import java.util.List;
import javax.annotation.Nullable;
import ladysnake.gaspunk.api.IBreathingHandler;
import ladysnake.gaspunk.api.IGasParticleType;
import ladysnake.gaspunk.api.IGasType;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IGas
extends IForgeRegistryEntry<IGas> {
    public IGasType getType();

    public boolean isToxic();

    default public void applyEffect(EntityLivingBase entity, IBreathingHandler handler, float concentration, boolean firstTick) {
        this.applyEffect(entity, handler, concentration, firstTick, false);
    }

    default public void applyEffect(EntityLivingBase entity, IBreathingHandler handler, float concentration, boolean firstTick, boolean forced) {
    }

    default public void onExitCloud(EntityLivingBase entity, IBreathingHandler handler) {
    }

    public int getColor();

    default public int getBottleColor() {
        return this.getColor();
    }

    default public IGasParticleType getParticleType() {
        return this.getType().getParticleType();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(float var1, float var2, ScaledResolution var3);

    default public String getUnlocalizedName() {
        return ("gas." + this.getRegistryName()).replace(':', '.');
    }

    @SideOnly(value=Side.CLIENT)
    default public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }
}

