/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gaspunk;

import javax.annotation.Nonnull;
import ladylib.LLibContainer;
import ladylib.LadyLib;
import ladysnake.gaspunk.CommonProxy;
import ladysnake.gaspunk.api.customization.IHasSkin;
import ladysnake.gaspunk.compat.ThaumcraftCompat;
import ladysnake.gaspunk.gas.Gas;
import ladysnake.gaspunk.init.ModItems;
import ladysnake.gaspunk.util.SpecialRewardChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gaspunk", name="GasPunk", version="1.4.8", dependencies="required-after:forge@[14.23.3.2669,);required-after:ladylib;after:jei;after:baubles;after:thaumcraft", guiFactory="ladysnake.gaspunk.client.config.GasPunkConfigFactory", certificateFingerprint="ba9369f9681b72713739250c7c0fee53dfb1c148", acceptedMinecraftVersions="[1.12.2]")
public class GasPunk {
    public static final String MOD_ID = "gaspunk";
    public static final String MOD_NAME = "GasPunk";
    public static final String VERSION = "1.4.8";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.3.2669,);required-after:ladylib;after:jei;after:baubles;after:thaumcraft";
    @SidedProxy(modId="gaspunk", serverSide="ladysnake.gaspunk.CommonProxy", clientSide="ladysnake.gaspunk.client.ClientProxy")
    public static CommonProxy proxy;
    public static final Logger LOGGER;
    @LadyLib.LLInstance(value="gaspunk")
    private static LLibContainer gaspunkLib;
    @LadyLib.LLInstance(value="pathos")
    private static LLibContainer pathosLib;
    public static final CreativeTabs CREATIVE_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        gaspunkLib.setCreativeTab(CREATIVE_TAB);
        pathosLib.setCreativeTab(CREATIVE_TAB);
        proxy.preInit(event);
        Gas.classInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        if (Loader.isModLoaded((String)"thaumcraft")) {
            ThaumcraftCompat.registerAspects();
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (LadyLib.isDevEnv()) {
            LOGGER.info("Ignoring invalid fingerprint as we are in a development environment");
        } else {
            LOGGER.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        CREATIVE_TAB = new GasPunkTabs();
    }

    public static class GasPunkTabs
    extends CreativeTabs {
        public GasPunkTabs() {
            super(GasPunk.MOD_ID);
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack(ModItems.GRENADE);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(@Nonnull NonNullList<ItemStack> itemList) {
            super.func_78018_a(itemList);
            itemList.stream().filter(stack -> stack.func_77973_b() instanceof IHasSkin).forEach(stack -> ((IHasSkin)stack.func_77973_b()).setSkin((ItemStack)stack, SpecialRewardChecker.getSelectedSkin((EntityPlayer)Minecraft.func_71410_x().field_71439_g)));
        }
    }
}

