/*
 * Decompiled with CFR 0.152.
 */
package trackapi.lib;

import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import trackapi.compat.MinecraftRail;
import trackapi.lib.ITrack;
import trackapi.lib.ITrackBlock;

public class Util {
    private static ITrack getInternalTileEntity(final World world, Vec3d pos, boolean acceptMinecraftRails) {
        final BlockPos bp = new BlockPos(Math.floor(pos.field_72450_a), Math.floor(pos.field_72448_b), Math.floor(pos.field_72449_c));
        IBlockState bs = world.func_180495_p(bp);
        if (bs.func_177230_c() instanceof ITrackBlock) {
            final ITrackBlock track = (ITrackBlock)bs.func_177230_c();
            return new ITrack(){

                @Override
                public double getTrackGauge() {
                    return track.getTrackGauge(world, bp);
                }

                @Override
                public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
                    return track.getNextPosition(world, bp, currentPosition, motion);
                }
            };
        }
        TileEntity te = world.func_175625_s(bp);
        if (te instanceof ITrack) {
            return (ITrack)te;
        }
        if (acceptMinecraftRails && MinecraftRail.isRail(world, bp)) {
            return new MinecraftRail(world, bp);
        }
        return null;
    }

    public static ITrack getTileEntity(World world, Vec3d pos, boolean acceptMinecraftRails) {
        ITrack track = Util.getInternalTileEntity(world, pos, acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        track = Util.getInternalTileEntity(world, pos.func_72441_c(0.0, 0.4, 0.0), acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        track = Util.getInternalTileEntity(world, pos.func_72441_c(0.0, -0.4, 0.0), acceptMinecraftRails);
        if (track != null) {
            return track;
        }
        return null;
    }
}

