/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClient;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClientConfig;
import com.feed_the_beast.ftbutilities.gui.GuiClaimedChunks;
import com.feed_the_beast.ftbutilities.net.MessageEditNBTRequest;
import com.feed_the_beast.ftbutilities.net.MessageLeaderboardList;
import com.feed_the_beast.ftbutilities.net.MessageRequestBadge;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbutilities", value={Side.CLIENT})
public class FTBUtilitiesClientEventHandler {
    private static final Map<UUID, Icon> BADGE_CACHE = new HashMap<UUID, Icon>();
    public static long shutdownTime = 0L;
    public static int currentPlaytime = 0;

    public static void readSyncData(NBTTagCompound nbt) {
        shutdownTime = System.currentTimeMillis() + nbt.func_74763_f("ShutdownTime");
    }

    public static Icon getBadge(UUID id) {
        Icon tex = BADGE_CACHE.get(id);
        if (tex == null) {
            tex = Icon.EMPTY;
            BADGE_CACHE.put(id, tex);
            new MessageRequestBadge(id).sendToServer();
        }
        return tex;
    }

    public static void setBadge(UUID id, String url) {
        BADGE_CACHE.put(id, Icon.getIcon((String)url));
    }

    @SubscribeEvent
    public static void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        BADGE_CACHE.clear();
        shutdownTime = 0L;
    }

    @SubscribeEvent
    public static void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        long timeLeft;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (shutdownTime > 0L && FTBUtilitiesClientConfig.general.show_shutdown_timer && (timeLeft = Math.max(0L, shutdownTime - System.currentTimeMillis())) > 0L && timeLeft <= FTBUtilitiesClientConfig.general.getShowShutdownTimer()) {
            event.getLeft().add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"ftbutilities.lang.timer.shutdown", (Object[])new Object[]{StringUtils.getTimeString((long)timeLeft)}));
        }
        if (FTBUtilitiesConfig.world.show_playtime) {
            event.getLeft().add(StatList.field_188097_g.func_150951_e().func_150260_c() + ": " + Ticks.get((long)Minecraft.func_71410_x().field_71439_g.func_146107_m().func_77444_a(StatList.field_188097_g)).toTimeString());
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBUtilitiesClient.KEY_NBT.func_151468_f()) {
            MessageEditNBTRequest.editNBT();
        }
        if (FTBUtilitiesClient.KEY_TRASH.func_151468_f()) {
            ClientUtils.execClientCommand((String)"/trash_can");
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbutilities")) {
            switch (event.getID().func_110623_a()) {
                case "toggle_gamemode": {
                    ClientUtils.execClientCommand((String)("/gamemode " + (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? "survival" : "creative")));
                    break;
                }
                case "daytime": {
                    long addDay = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)FTBUtilitiesClientConfig.general.button_daytime) % 24000L;
                    if (addDay == 0L) break;
                    ClientUtils.execClientCommand((String)("/time add " + addDay));
                    break;
                }
                case "nighttime": {
                    long addNight = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)FTBUtilitiesClientConfig.general.button_nighttime) % 24000L;
                    if (addNight == 0L) break;
                    ClientUtils.execClientCommand((String)("/time add " + addNight));
                    break;
                }
                case "claims_gui": {
                    GuiClaimedChunks.instance = new GuiClaimedChunks();
                    GuiClaimedChunks.instance.openGui();
                    break;
                }
                case "leaderboards_gui": {
                    new MessageLeaderboardList().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientWorldTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && mc.field_71441_e.field_73011_w.getDimension() == FTBUtilitiesConfig.world.spawn_dimension) {
            if (FTBUtilitiesConfig.world.forced_spawn_dimension_time != -1) {
                mc.field_71441_e.func_72877_b((long)FTBUtilitiesConfig.world.forced_spawn_dimension_time);
            }
            if (FTBUtilitiesConfig.world.forced_spawn_dimension_weather != -1) {
                mc.field_71441_e.func_72912_H().func_76084_b(FTBUtilitiesConfig.world.forced_spawn_dimension_weather >= 1);
                mc.field_71441_e.func_72912_H().func_76069_a(FTBUtilitiesConfig.world.forced_spawn_dimension_weather >= 2);
            }
        }
    }
}

