/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.util.EnumFacing;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultipartBakedModel.class})
public class MixinMultipartBakedModel {
    private final Map<IBlockState, IBakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private Map<Predicate<IBlockState>, IBakedModel> field_188626_f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long random) {
        IBakedModel[] models;
        if (state == null) {
            return Collections.emptyList();
        }
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<IBakedModel> modelList = new ArrayList<IBakedModel>(this.field_188626_f.size());
                for (Map.Entry<Predicate<IBlockState>, IBakedModel> pair : this.field_188626_f.entrySet()) {
                    if (!pair.getKey().test((Object)state)) continue;
                    modelList.add(pair.getValue());
                }
                models = modelList.toArray(new IBakedModel[modelList.size()]);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (IBakedModel model : models) {
            quads.addAll(model.func_188616_a(state, face, random));
        }
        return quads;
    }
}

