/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiOverlayDebug.class})
public abstract class MixinDebugHud {
    @Shadow
    @Final
    private Minecraft field_175242_a;
    @Shadow
    @Final
    private FontRenderer field_175241_f;
    private List<String> capturedList = null;

    @Redirect(method={"renderDebugInfoLeft", "renderDebugInfoRight"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I"))
    private int preRenderText(List<String> list) {
        this.capturedList = list;
        return 0;
    }

    @Inject(method={"renderDebugInfoLeft"}, at={@At(value="RETURN")})
    public void renderLeftText(CallbackInfo ci) {
        this.renderCapturedText(new ScaledResolution(this.field_175242_a), false);
    }

    @Inject(method={"renderDebugInfoRight"}, at={@At(value="RETURN")})
    public void renderRightText(ScaledResolution resolution, CallbackInfo ci) {
        this.renderCapturedText(resolution, true);
    }

    private void renderCapturedText(ScaledResolution resolution, boolean right) {
        Validate.notNull(this.capturedList, (String)"Failed to capture string list", (Object[])new Object[0]);
        this.renderBackdrop(resolution, this.capturedList, right);
        this.renderStrings(resolution, this.capturedList, right);
        this.capturedList = null;
    }

    private void renderStrings(ScaledResolution resolution, List<String> list, boolean right) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.field_175241_f.func_78256_a(string);
            float x1 = right ? (float)(resolution.func_78326_a() - 2 - width) : 2.0f;
            float y1 = 2 + height * i;
            this.field_175241_f.func_78276_b(string, (int)x1, (int)y1, 0xE0E0E0);
        }
    }

    private void renderBackdrop(ScaledResolution resolution, List<String> list, boolean right) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int color = -1873784752;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.field_175241_f.func_78256_a(string);
            int x = right ? resolution.func_78326_a() - 2 - width : 2;
            int y = 2 + height * i;
            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;
            bufferBuilder.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(g, h, k, f).func_181675_d();
            bufferBuilder.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(g, h, k, f).func_181675_d();
            bufferBuilder.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(g, h, k, f).func_181675_d();
            bufferBuilder.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(g, h, k, f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

