/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import java.util.Map;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class})
public abstract class MixinWorldRenderer {
    @Shadow
    @Final
    private Map<Integer, DestroyBlockProgress> field_72738_E;
    @Shadow
    @Final
    private Minecraft field_72777_q;
    private SodiumWorldRenderer renderer;

    @Shadow
    private void func_174982_a(BlockRenderLayer blockLayerIn) {
    }

    @Redirect(method={"loadRenderers"}, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;renderDistanceChunks:I", ordinal=1))
    private int nullifyBuiltChunkStorage(GameSettings settings) {
        return 0;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Minecraft minecraft, CallbackInfo ci) {
        this.renderer = SodiumWorldRenderer.create();
    }

    @Inject(method={"setWorldAndLoadRenderers"}, at={@At(value="RETURN")})
    private void onWorldChanged(WorldClient world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public int func_184382_g() {
        return this.renderer.getVisibleChunkCount();
    }

    @Overwrite
    public boolean func_184384_n() {
        return this.renderer.isTerrainRenderComplete();
    }

    @Inject(method={"setDisplayListEntitiesDirty"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public int func_174977_a(BlockRenderLayer blockLayerIn, double partialTicks, int pass, Entity entityIn) {
        RenderDevice.enterManagedCode();
        RenderHelper.func_74518_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179144_i((int)this.field_72777_q.func_147117_R().func_110552_b());
        GlStateManager.func_179098_w();
        this.field_72777_q.field_71460_t.func_180436_i();
        double d3 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * partialTicks;
        double d4 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * partialTicks;
        double d5 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * partialTicks;
        try {
            this.renderer.drawChunkLayer(blockLayerIn, d3, d4, d5);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
        this.field_72777_q.field_71460_t.func_175072_h();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_174970_a(Entity entity, double tick, ICamera camera, int frame, boolean spectator) {
        RenderDevice.enterManagedCode();
        boolean hasForcedFrustum = false;
        try {
            this.renderer.updateChunks((Frustum)camera, (float)tick, hasForcedFrustum, frame, spectator);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    private void func_184385_a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, important);
    }

    @Redirect(method={"updateClouds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher;hasNoFreeRenderBuilders()Z"))
    private boolean alwaysHaveBuilders(ChunkRenderDispatcher instance) {
        return false;
    }

    @Redirect(method={"updateClouds"}, at=@At(value="INVOKE", target="Ljava/util/Set;isEmpty()Z", ordinal=1))
    private boolean alwaysHaveNoTasks(Set instance) {
        return true;
    }

    @Inject(method={"loadRenderers"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderHelper;enableStandardItemLighting()V", shift=At.Shift.AFTER, ordinal=1)}, cancellable=true)
    public void sodium$renderTileEntities(Entity entity, ICamera camera, float partialTicks, CallbackInfo ci) {
        this.renderer.renderTileEntities(partialTicks, this.field_72738_E);
        this.field_72777_q.field_71460_t.func_175072_h();
        this.field_72777_q.field_71424_I.func_76319_b();
        ci.cancel();
    }

    @Overwrite
    public String func_72735_c() {
        return this.renderer.getChunksDebugString();
    }
}

