/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.block;

import java.util.List;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.math.MatrixStack;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={BlockModelRenderer.class})
public class MixinBlockModelRenderer {
    private final XoRoShiRoRandom random = new XoRoShiRoRandom();

    @Overwrite
    public boolean func_187493_a(IBlockAccess world, IBakedModel bakedModel, IBlockState blockState, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand) {
        boolean flag = false;
        QuadVertexSink drain = VertexDrain.of(buffer).createSink(VanillaVertexTypes.QUADS);
        XoRoShiRoRandom random = this.random;
        MatrixStack matrixStack = new MatrixStack();
        random.setSeed(42L);
        for (EnumFacing direction : DirectionUtil.ALL_DIRECTIONS) {
            List quads = bakedModel.func_188616_a(blockState, direction, random.nextLong());
            if (quads.isEmpty()) continue;
            MixinBlockModelRenderer.renderQuad(matrixStack.peek(), drain, quads, 200, 0);
            flag = true;
        }
        random.setSeed(42L);
        List quads = bakedModel.func_188616_a(blockState, null, random.nextLong());
        if (!quads.isEmpty()) {
            MixinBlockModelRenderer.renderQuad(matrixStack.peek(), drain, quads, 200, 0);
            flag = true;
        }
        drain.flush();
        return flag;
    }

    private static void renderQuad(MatrixStack.Entry entry, QuadVertexSink drain, List<BakedQuad> list, int light, int overlay) {
        if (list.isEmpty()) {
            return;
        }
        drain.ensureCapacity(list.size() * 4);
        for (BakedQuad bakedQuad : list) {
            int color = bakedQuad.func_178212_b() ? bakedQuad.func_178211_c() : -1;
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                drain.writeQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), color, quad.getTexU(i), quad.getTexV(i), light, overlay, ModelQuadUtil.getFacingNormal(bakedQuad.func_178210_d(), quad.getNormal(i)));
            }
            SpriteUtil.markSpriteActive(quad.rubidium$getSprite());
        }
    }
}

