/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.color;

import java.util.function.Function;
import net.minecraft.util.math.MathHelper;
import repack.joml.Math;
import repack.joml.Vector3d;

public class FastCubicSampler {
    private static final double[] DENSITY_CURVE = new double[]{0.0, 1.0, 4.0, 6.0, 4.0, 1.0, 0.0};
    private static final int DIAMETER = 6;

    private static Vector3d unpackRgb(int rgb) {
        return new Vector3d((double)(rgb >> 16 & 0xFF) / 255.0, (double)(rgb >> 8 & 0xFF) / 255.0, (double)(rgb & 0xFF) / 255.0);
    }

    public static Vector3d sampleColor(Vector3d pos, ColorFetcher colorFetcher, Function<Vector3d, Vector3d> transformer) {
        int intX = MathHelper.func_76128_c((double)pos.x);
        int intY = MathHelper.func_76128_c((double)pos.y);
        int intZ = MathHelper.func_76128_c((double)pos.z);
        int[] values = new int[216];
        for (int x = 0; x < 6; ++x) {
            int blockX = intX - 2 + x;
            for (int y = 0; y < 6; ++y) {
                int blockY = intY - 2 + y;
                for (int z = 0; z < 6; ++z) {
                    int blockZ = intZ - 2 + z;
                    values[FastCubicSampler.index((int)x, (int)y, (int)z)] = colorFetcher.fetch(blockX, blockY, blockZ);
                }
            }
        }
        if (FastCubicSampler.isHomogenousArray(values)) {
            return transformer.apply(FastCubicSampler.unpackRgb(values[0]));
        }
        double deltaX = pos.x - (double)intX;
        double deltaY = pos.y - (double)intY;
        double deltaZ = pos.z - (double)intZ;
        Vector3d sum = new Vector3d();
        double totalFactor = 0.0;
        for (int x = 0; x < 6; ++x) {
            double densityX = Math.lerp(DENSITY_CURVE[x + 1], DENSITY_CURVE[x], deltaX);
            for (int y = 0; y < 6; ++y) {
                double densityY = Math.lerp(DENSITY_CURVE[y + 1], DENSITY_CURVE[y], deltaY);
                for (int z = 0; z < 6; ++z) {
                    double densityZ = Math.lerp(DENSITY_CURVE[z + 1], DENSITY_CURVE[z], deltaZ);
                    double factor = densityX * densityY * densityZ;
                    totalFactor += factor;
                    Vector3d color = transformer.apply(FastCubicSampler.unpackRgb(values[FastCubicSampler.index(x, y, z)]));
                    sum.add(color.mul(factor));
                }
            }
        }
        sum.mul(1.0 / totalFactor);
        return sum;
    }

    private static int index(int x, int y, int z) {
        return 36 * z + 6 * y + x;
    }

    private static boolean isHomogenousArray(int[] arr) {
        int val = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] == val) continue;
            return false;
        }
        return true;
    }

    public static interface ColorFetcher {
        public int fetch(int var1, int var2, int var3);
    }
}

