/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import org.embeddedt.embeddium.render.fluid.EmbeddiumFluidSpriteCache;
import repack.joml.Vector3d;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private static final IBlockColor FLUID_COLOR_PROVIDER = (state, world, pos, tintIndex) -> WorldUtil.getFluid(state).getColor();
    private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final BiomeColorBlender biomeColorBlender;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final EmbeddiumFluidSpriteCache fluidSpriteCache = new EmbeddiumFluidSpriteCache();
    private final BlockColors vanillaBlockColors;

    public FluidRenderer(Minecraft client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        int normal = Norm3b.pack(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.quad.setNormal(i, normal);
        }
        this.lighters = lighters;
        this.biomeColorBlender = biomeColorBlender;
        this.vanillaBlockColors = client.func_184125_al();
    }

    private boolean isFluidOccluded(IBlockAccess world, int x, int y, int z, EnumFacing dir, Fluid fluid) {
        BlockPos.MutableBlockPos pos = this.scratchPos.func_181079_c(x, y, z);
        IBlockState blockState = world.func_180495_p((BlockPos)pos);
        BlockPos.MutableBlockPos adjPos = this.scratchPos.func_181079_c(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
        Fluid adjFluid = WorldUtil.getFluid(world.func_180495_p((BlockPos)adjPos));
        if (blockState.func_185904_a().func_76218_k()) {
            return fluid == adjFluid || blockState.isSideSolid(world, (BlockPos)pos, dir);
        }
        return fluid == adjFluid;
    }

    private boolean isSideExposed(IBlockAccess world, int x, int y, int z, EnumFacing dir) {
        BlockPos.MutableBlockPos pos = this.scratchPos.func_181079_c(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
        IBlockState blockState = world.func_180495_p((BlockPos)pos);
        if (blockState.func_185904_a().func_76218_k()) {
            BlockFaceShape shape = blockState.func_193401_d(world, (BlockPos)pos, dir);
            if (shape == BlockFaceShape.SOLID) {
                return dir == EnumFacing.UP;
            }
            if (shape == BlockFaceShape.UNDEFINED) {
                return true;
            }
        }
        return true;
    }

    public boolean render(IBlockAccess world, IBlockState fluidState, BlockPos pos, ChunkModelBuffers buffers) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        Fluid fluid = WorldUtil.toFluidBlock(fluidState.func_177230_c()).getFluid();
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.UP, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.DOWN, fluid) || !this.isSideExposed(world, posX, posY, posZ, EnumFacing.DOWN);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.NORTH, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.SOUTH, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.WEST, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, EnumFacing.EAST, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return false;
        }
        TextureAtlasSprite[] sprites = this.fluidSpriteCache.getSprites(fluid);
        boolean hc = fluidState.func_177230_c() != Blocks.field_150353_l && fluidState.func_177230_c() != Blocks.field_150356_k;
        boolean rendered = false;
        float h1 = this.getCornerHeight(world, posX, posY, posZ, fluid);
        float h2 = this.getCornerHeight(world, posX, posY, posZ + 1, fluid);
        float h3 = this.getCornerHeight(world, posX + 1, posY, posZ + 1, fluid);
        float h4 = this.getCornerHeight(world, posX + 1, posY, posZ, fluid);
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = hc && Minecraft.func_71379_u() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, EnumFacing.UP)) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            TextureAtlasSprite sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            Vector3d velocity = WorldUtil.getVelocity(world, pos, fluidState);
            if (velocity.x == 0.0 && velocity.z == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.UP;
                u1 = sprite.func_94214_a(0.0);
                v1 = sprite.func_94207_b(0.0);
                u2 = u1;
                v2 = sprite.func_94207_b(16.0);
                u3 = sprite.func_94214_a(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)MathHelper.func_181159_b((double)velocity.z, (double)velocity.x) - 1.5707964f;
                float sin = MathHelper.func_76126_a((float)dir) * 0.25f;
                float cos = MathHelper.func_76134_b((float)dir) * 0.25f;
                u1 = sprite.func_94214_a((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.func_94207_b((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.func_94214_a((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.func_94207_b((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.func_94214_a((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.func_94207_b((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.func_94214_a((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.func_94207_b((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].func_94211_a() / (sprites[0].func_94212_f() - sprites[0].func_94209_e());
            float s2 = (float)sprites[0].func_94216_b() / (sprites[0].func_94210_h() - sprites[0].func_94206_g());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = (float)MathUtil.lerp(s3, u1, uAvg);
            u2 = (float)MathUtil.lerp(s3, u2, uAvg);
            u3 = (float)MathUtil.lerp(s3, u3, uAvg);
            u4 = (float)MathUtil.lerp(s3, u4, uAvg);
            v1 = (float)MathUtil.lerp(s3, v1, vAvg);
            v2 = (float)MathUtil.lerp(s3, v2, vAvg);
            v3 = (float)MathUtil.lerp(s3, v3, vAvg);
            v4 = (float)MathUtil.lerp(s3, v4, vAvg);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, h1, 0.0f, u1, v1);
            this.setVertex(quad, 1, 0.0f, h2, 1.0f, u2, v2);
            this.setVertex(quad, 2, 1.0f, h3, 1.0f, u3, v3);
            this.setVertex(quad, 3, 1.0f, h4, 0.0f, u4, v4);
            this.calculateQuadColors(quad, world, pos, lighter, EnumFacing.UP, 1.0f, hc);
            this.flushQuad(buffers, quad, facing, false);
            if (WorldUtil.method_15756(world, (BlockPos)this.scratchPos.func_181079_c(posX, posY + 1, posZ), fluid)) {
                this.setVertex(quad, 3, 0.0f, h1, 0.0f, u1, v1);
                this.setVertex(quad, 2, 0.0f, h2, 1.0f, u2, v2);
                this.setVertex(quad, 1, 1.0f, h3, 1.0f, u3, v3);
                this.setVertex(quad, 0, 1.0f, h4, 0.0f, u4, v4);
                this.flushQuad(buffers, quad, ModelQuadFacing.DOWN, true);
            }
            rendered = true;
        }
        if (!sfDown) {
            TextureAtlasSprite sprite = sprites[0];
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            this.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            this.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            this.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.calculateQuadColors(quad, world, pos, lighter, EnumFacing.DOWN, 1.0f, hc);
            this.flushQuad(buffers, quad, ModelQuadFacing.DOWN, false);
            rendered = true;
        }
        quad.setFlags(4);
        block6: for (EnumFacing dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            BlockPos.MutableBlockPos adjPos;
            IBlockState adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir)) continue;
            int adjX = posX + dir.func_82601_c();
            int adjY = posY + dir.func_96559_d();
            int adjZ = posZ + dir.func_82599_e();
            TextureAtlasSprite sprite = sprites[1];
            TextureAtlasSprite oSprite = sprites[2];
            if (oSprite != null && (adjBlock = world.func_180495_p((BlockPos)(adjPos = this.scratchPos.func_181079_c(adjX, adjY, adjZ)))).func_193401_d(world, (BlockPos)adjPos, dir.func_176734_d()) == BlockFaceShape.SOLID) {
                sprite = oSprite;
            }
            float u1 = sprite.func_94214_a(0.0);
            float u2 = sprite.func_94214_a(8.0);
            float v1 = sprite.func_94207_b((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.func_94207_b((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.func_94207_b(8.0);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, x2, c2, z2, u2, v2);
            this.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            this.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            this.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.func_176740_k() == EnumFacing.Axis.Z ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.calculateQuadColors(quad, world, pos, lighter, dir, br, hc);
            this.flushQuad(buffers, quad, facing, false);
            if (sprite != oSprite) {
                this.setVertex(quad, 0, x1, c1, z1, u1, v1);
                this.setVertex(quad, 1, x1, yOffset, z1, u1, v3);
                this.setVertex(quad, 2, x2, yOffset, z2, u2, v3);
                this.setVertex(quad, 3, x2, c2, z2, u2, v2);
                this.flushQuad(buffers, quad, facing.getOpposite(), true);
            }
            rendered = true;
        }
        return rendered;
    }

    private void calculateQuadColors(ModelQuadView quad, IBlockAccess world, BlockPos pos, LightPipeline lighter, EnumFacing dir, float brightness, boolean colorized) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false);
        int[] biomeColors = null;
        if (colorized) {
            IBlockState state = world.func_180495_p(pos);
            IBlockColor colorProvider = ((BlockColorsExtended)this.vanillaBlockColors).getColorProvider(state);
            boolean containsColoredQuad = false;
            if (colorProvider != null) {
                for (int color : biomeColors = this.biomeColorBlender.getColors(colorProvider, world, state, pos, quad)) {
                    if (color == 0xFFFFFF) continue;
                    containsColoredQuad = true;
                    break;
                }
            }
            if (!containsColoredQuad) {
                biomeColors = this.biomeColorBlender.getColors(FLUID_COLOR_PROVIDER, world, state, pos, quad);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private void flushQuad(ChunkModelBuffers buffers, ModelQuadView quad, ModelQuadFacing facing, boolean flip) {
        int lightOrder;
        int vertexIdx;
        if (flip) {
            vertexIdx = 3;
            lightOrder = -1;
        } else {
            vertexIdx = 0;
            lightOrder = 1;
        }
        ModelVertexSink sink = buffers.getSink(facing);
        sink.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float x = quad.getX(i);
            float y = quad.getY(i);
            float z = quad.getZ(i);
            int color = this.quadColors[vertexIdx];
            float u = quad.getTexU(i);
            float v = quad.getTexV(i);
            int light = this.quadLightData.lm[vertexIdx];
            sink.writeQuad(x, y, z, color, u, v, light);
            vertexIdx += lightOrder;
        }
        TextureAtlasSprite sprite = quad.rubidium$getSprite();
        if (sprite != null) {
            buffers.getRenderData().addSprite(sprite);
        }
        sink.flush();
    }

    private void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float getCornerHeight(IBlockAccess world, int x, int y, int z, Fluid fluid) {
        int samples = 0;
        float totalHeight = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int x2 = x - (i & 1);
            int z2 = z - (i >> 1 & 1);
            Block block = world.func_180495_p((BlockPos)this.scratchPos.func_181079_c(x2, y + 1, z2)).func_177230_c();
            if (WorldUtil.getFluidOfBlock(block) == fluid) {
                return 1.0f;
            }
            BlockPos.MutableBlockPos pos = this.scratchPos.func_181079_c(x2, y, z2);
            IBlockState blockState = world.func_180495_p((BlockPos)pos);
            Fluid fluid2 = WorldUtil.getFluidOfBlock(blockState.func_177230_c());
            if (fluid == fluid2) {
                float height = WorldUtil.getFluidHeight(fluid2, (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b));
                if (height >= 0.8f) {
                    totalHeight += height * 10.0f;
                    samples += 10;
                    continue;
                }
                totalHeight += height;
                ++samples;
                continue;
            }
            if (blockState.func_185904_a().func_76220_a()) continue;
            ++samples;
        }
        return totalHeight / (float)samples;
    }
}

