/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.passes;

import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.minecraft.util.BlockRenderLayer;

public class BlockRenderPassManager {
    private final Reference2IntArrayMap<BlockRenderLayer> mappingsId = new Reference2IntArrayMap();

    public BlockRenderPassManager() {
        this.mappingsId.defaultReturnValue(-1);
    }

    public int getRenderPassId(BlockRenderLayer layer) {
        int pass = this.mappingsId.getInt((Object)layer);
        if (pass < 0) {
            throw new NullPointerException("No render pass exists for layer: " + layer);
        }
        return pass;
    }

    private void addMapping(BlockRenderLayer layer, BlockRenderPass type) {
        if (this.mappingsId.put((Object)layer, type.ordinal()) >= 0) {
            throw new IllegalArgumentException("Layer target already defined for " + layer);
        }
    }

    public static BlockRenderPassManager createDefaultMappings() {
        BlockRenderPassManager mapper = new BlockRenderPassManager();
        mapper.addMapping(BlockRenderLayer.SOLID, BlockRenderPass.SOLID);
        mapper.addMapping(BlockRenderLayer.CUTOUT_MIPPED, BlockRenderPass.CUTOUT_MIPPED);
        mapper.addMapping(BlockRenderLayer.CUTOUT, BlockRenderPass.CUTOUT);
        mapper.addMapping(BlockRenderLayer.TRANSLUCENT, BlockRenderPass.TRANSLUCENT);
        return mapper;
    }

    public BlockRenderPass getRenderPassForLayer(BlockRenderLayer layer) {
        return this.getRenderPass(this.getRenderPassId(layer));
    }

    public BlockRenderPass getRenderPass(int i) {
        return BlockRenderPass.VALUES[i];
    }
}

