/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw;

import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferSegment;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttribute;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.func.GlFunctions;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.TessellationBinding;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.ChunkDrawCallBatcher;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.ChunkDrawParamsVector;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.IndirectCommandBufferVector;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderListIterator;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.ChunkRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkRenderShaderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderBindingPoints;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;

public class MultidrawChunkRenderBackend
extends ChunkRenderShaderBackend<MultidrawGraphicsState> {
    private final ChunkRegionManager<MultidrawGraphicsState> bufferManager;
    private final ObjectArrayList<ChunkRegion<MultidrawGraphicsState>> pendingBatches = new ObjectArrayList();
    private final ObjectArrayFIFOQueue<ChunkRegion<MultidrawGraphicsState>> pendingUploads = new ObjectArrayFIFOQueue();
    private final GlMutableBuffer uploadBuffer;
    private final GlMutableBuffer uniformBuffer;
    private final GlMutableBuffer commandBuffer;
    private final ChunkDrawParamsVector uniformBufferBuilder;
    private final IndirectCommandBufferVector commandClientBufferBuilder;
    private boolean reverseRegions = false;
    private ChunkCameraContext regionCamera;
    private static final Comparator<ChunkRegion<?>> REGION_REVERSER = Comparator.comparingDouble(r -> r.camDistance).reversed();
    private static final Pattern INTEL_BUILD_MATCHER = Pattern.compile("(\\d.\\d.\\d) - Build (\\d+).(\\d+).(\\d+).(\\d+)");
    private static final String INTEL_VENDOR_NAME = "Intel";

    public MultidrawChunkRenderBackend(RenderDevice device, ChunkVertexType vertexType) {
        super(vertexType);
        this.bufferManager = new ChunkRegionManager(device);
        try (CommandList commands = device.createCommandList();){
            this.uploadBuffer = commands.createMutableBuffer(GlBufferUsage.GL_STREAM_DRAW);
            this.uniformBuffer = commands.createMutableBuffer(GlBufferUsage.GL_STATIC_DRAW);
            this.commandBuffer = MultidrawChunkRenderBackend.isWindowsIntelDriver() ? null : commands.createMutableBuffer(GlBufferUsage.GL_STREAM_DRAW);
        }
        this.uniformBufferBuilder = ChunkDrawParamsVector.create(2048);
        this.commandClientBufferBuilder = IndirectCommandBufferVector.create(2048);
    }

    @Override
    public void upload(CommandList commandList, Iterator<ChunkBuildResult<MultidrawGraphicsState>> queue) {
        if (queue != null) {
            this.setupUploadBatches(queue);
        }
        commandList.bindBuffer(GlBufferTarget.ARRAY_BUFFER, this.uploadBuffer);
        while (!this.pendingUploads.isEmpty()) {
            ChunkRegion region = (ChunkRegion)this.pendingUploads.dequeue();
            GlBufferArena arena = region.getBufferArena();
            GlBuffer buffer = arena.getBuffer();
            ObjectArrayList uploadQueue = region.getUploadQueue();
            arena.prepareBuffer(commandList, MultidrawChunkRenderBackend.getUploadQueuePayloadSize(uploadQueue));
            for (ChunkBuildResult result : uploadQueue) {
                ChunkRenderContainer<MultidrawGraphicsState> render = result.render;
                ChunkRenderData data = result.data;
                for (BlockRenderPass pass : result.passesToUpload) {
                    ChunkMeshData meshData;
                    MultidrawGraphicsState graphics = (MultidrawGraphicsState)render.getGraphicsState(pass);
                    if (graphics != null) {
                        graphics.delete(commandList);
                    }
                    if ((meshData = data.getMesh(pass)).hasVertexData()) {
                        VertexData upload = meshData.takeVertexData();
                        commandList.uploadData(this.uploadBuffer, upload.buffer);
                        GlBufferSegment segment = arena.uploadBuffer(commandList, this.uploadBuffer, 0, upload.buffer.capacity());
                        MultidrawGraphicsState graphicsState = new MultidrawGraphicsState(render, region, segment, meshData, this.vertexFormat);
                        if (pass.isTranslucent()) {
                            upload.buffer.limit(upload.buffer.capacity());
                            upload.buffer.position(0);
                            graphicsState.setTranslucencyData(upload.buffer);
                        }
                        render.setGraphicsState(pass, graphicsState);
                        continue;
                    }
                    render.setGraphicsState(pass, null);
                }
                render.setData(data);
            }
            if (region.getTessellation() == null || buffer != arena.getBuffer()) {
                if (region.getTessellation() != null) {
                    commandList.deleteTessellation(region.getTessellation());
                }
                region.setTessellation(this.createRegionTessellation(commandList, arena.getBuffer()));
            }
            uploadQueue.clear();
        }
        commandList.invalidateBuffer(this.uploadBuffer);
    }

    private GlTessellation createRegionTessellation(CommandList commandList, GlBuffer buffer) {
        return commandList.createTessellation(GlPrimitiveType.QUADS, new TessellationBinding[]{new TessellationBinding(buffer, new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(ChunkShaderBindingPoints.POSITION, this.vertexFormat.getAttribute(ChunkMeshAttribute.POSITION)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.COLOR, this.vertexFormat.getAttribute(ChunkMeshAttribute.COLOR)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.TEX_COORD, this.vertexFormat.getAttribute(ChunkMeshAttribute.TEXTURE)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.LIGHT_COORD, this.vertexFormat.getAttribute(ChunkMeshAttribute.LIGHT))}, false), new TessellationBinding(this.uniformBuffer, new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(ChunkShaderBindingPoints.MODEL_OFFSET, new GlVertexAttribute(GlVertexAttributeFormat.FLOAT, 4, false, 0, 0))}, true)});
    }

    public void setReverseRegions(boolean flag) {
        this.reverseRegions = flag;
    }

    @Override
    public void render(CommandList commandList, ChunkRenderListIterator<MultidrawGraphicsState> renders, ChunkCameraContext camera) {
        ByteBuffer pointerBuffer;
        this.bufferManager.cleanup();
        this.setupDrawBatches(commandList, renders, camera);
        this.buildCommandBuffer();
        if (this.commandBuffer != null) {
            commandList.bindBuffer(GlBufferTarget.DRAW_INDIRECT_BUFFER, this.commandBuffer);
            commandList.uploadData(this.commandBuffer, this.commandClientBufferBuilder.getBuffer());
        }
        long pointer = 0L;
        int originalPointerBufferPos = 0;
        if (this.commandBuffer != null) {
            pointerBuffer = null;
        } else {
            pointerBuffer = this.commandClientBufferBuilder.getBuffer();
            originalPointerBufferPos = pointerBuffer.position();
        }
        for (ChunkRegion region : this.pendingBatches) {
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            if (!batch.isEmpty()) {
                try (DrawCommandList drawCommandList = commandList.beginTessellating(region.getTessellation());){
                    if (pointerBuffer == null) {
                        drawCommandList.multiDrawArraysIndirect(pointer, batch.getCount(), 0);
                    } else {
                        drawCommandList.multiDrawArraysIndirect(pointerBuffer, batch.getCount(), 0);
                    }
                }
            }
            if (pointerBuffer == null) {
                pointer += (long)batch.getArrayLength();
                continue;
            }
            pointerBuffer.position(pointerBuffer.position() + batch.getArrayLength());
        }
        if (pointerBuffer != null) {
            pointerBuffer.position(originalPointerBufferPos);
        }
        this.pendingBatches.clear();
    }

    private void buildCommandBuffer() {
        this.commandClientBufferBuilder.begin();
        if (this.reverseRegions) {
            ChunkCameraContext camera = this.regionCamera;
            for (ChunkRegion region : this.pendingBatches) {
                float x = camera.getChunkModelOffset(region.getCenterBlockX(), camera.blockOriginX, camera.originX);
                float y = camera.getChunkModelOffset(region.getCenterBlockY(), camera.blockOriginY, camera.originY);
                float z = camera.getChunkModelOffset(region.getCenterBlockZ(), camera.blockOriginZ, camera.originZ);
                region.camDistance = x * x + y * y + z * z;
            }
            this.pendingBatches.sort(REGION_REVERSER);
        }
        for (ChunkRegion region : this.pendingBatches) {
            ChunkDrawCallBatcher batcher = region.getDrawBatcher();
            batcher.end();
            this.commandClientBufferBuilder.pushCommandBuffer(batcher);
        }
        this.commandClientBufferBuilder.end();
    }

    private void setupUploadBatches(Iterator<ChunkBuildResult<MultidrawGraphicsState>> renders) {
        while (renders.hasNext()) {
            ObjectArrayList<ChunkBuildResult<MultidrawGraphicsState>> uploadQueue;
            ChunkBuildResult<MultidrawGraphicsState> result = renders.next();
            if (result == null) continue;
            ChunkRenderContainer render = result.render;
            ChunkRegion<MultidrawGraphicsState> region = this.bufferManager.getRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            if (region == null) {
                if (result.data.getMeshSize() <= 0) {
                    render.setData(result.data);
                    continue;
                }
                region = this.bufferManager.getOrCreateRegion(render.getChunkX(), render.getChunkY(), render.getChunkZ());
            }
            if ((uploadQueue = region.getUploadQueue()).isEmpty()) {
                this.pendingUploads.enqueue(region);
            }
            uploadQueue.add(result);
        }
    }

    private void setupDrawBatches(CommandList commandList, ChunkRenderListIterator<MultidrawGraphicsState> it, ChunkCameraContext camera) {
        this.uniformBufferBuilder.reset();
        this.regionCamera = camera;
        int drawCount = 0;
        while (it.hasNext()) {
            MultidrawGraphicsState state = it.getGraphicsState();
            int visible = it.getVisibleFaces();
            int index = drawCount++;
            float x = camera.getChunkModelOffset(state.getX(), camera.blockOriginX, camera.originX);
            float y = camera.getChunkModelOffset(state.getY(), camera.blockOriginY, camera.originY);
            float z = camera.getChunkModelOffset(state.getZ(), camera.blockOriginZ, camera.originZ);
            this.uniformBufferBuilder.pushChunkDrawParams(x, y, z);
            ChunkRegion<MultidrawGraphicsState> region = state.getRegion();
            ChunkDrawCallBatcher batch = region.getDrawBatcher();
            if (!batch.isBuilding()) {
                batch.begin();
                this.pendingBatches.add(region);
            }
            int mask = 1;
            for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
                if ((visible & mask) != 0) {
                    long part = state.getModelPart(i);
                    batch.addIndirectDrawCall(BufferSlice.unpackStart(part), BufferSlice.unpackLength(part), index, 1);
                }
                mask <<= 1;
            }
            it.advance();
        }
        commandList.uploadData(this.uniformBuffer, this.uniformBufferBuilder.getBuffer());
    }

    private static int getUploadQueuePayloadSize(List<ChunkBuildResult<MultidrawGraphicsState>> queue) {
        int size = 0;
        for (ChunkBuildResult<MultidrawGraphicsState> result : queue) {
            size += result.data.getMeshSize();
        }
        return size;
    }

    @Override
    public void delete() {
        super.delete();
        try (CommandList commands = RenderDevice.INSTANCE.createCommandList();){
            commands.deleteBuffer(this.uploadBuffer);
            commands.deleteBuffer(this.uniformBuffer);
            if (this.commandBuffer != null) {
                commands.deleteBuffer(this.commandBuffer);
            }
        }
        this.bufferManager.delete();
        this.commandClientBufferBuilder.delete();
        this.uniformBufferBuilder.delete();
    }

    @Override
    public Class<MultidrawGraphicsState> getGraphicsStateType() {
        return MultidrawGraphicsState.class;
    }

    public static boolean isSupported(boolean disableDriverBlacklist) {
        if (!disableDriverBlacklist && MultidrawChunkRenderBackend.isKnownBrokenIntelDriver()) {
            return false;
        }
        return GlFunctions.isVertexArraySupported() && GlFunctions.isBufferCopySupported() && GlFunctions.isIndirectMultiDrawSupported() && GlFunctions.isInstancedArraySupported();
    }

    private static boolean isWindowsIntelDriver() {
        if (Util.func_110647_a() != Util.EnumOS.WINDOWS) {
            return false;
        }
        return Objects.equals(GlStateManager.func_187416_u((int)7936), INTEL_VENDOR_NAME);
    }

    private static boolean isKnownBrokenIntelDriver() {
        if (!MultidrawChunkRenderBackend.isWindowsIntelDriver()) {
            return false;
        }
        String version = GlStateManager.func_187416_u((int)7938);
        if (version == null) {
            return false;
        }
        Matcher matcher = INTEL_BUILD_MATCHER.matcher(version);
        if (!matcher.matches()) {
            return false;
        }
        return Integer.parseInt(matcher.group(4)) < 100;
    }

    @Override
    public String getRendererName() {
        return "Multidraw";
    }

    @Override
    public List<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.format("Active Buffers: %s", this.bufferManager.getAllocatedRegionCount()));
        list.add(String.format("Submission Mode: %s", this.commandBuffer != null ? TextFormatting.AQUA + "Buffer" : TextFormatting.LIGHT_PURPLE + "Client Memory"));
        return list;
    }
}

