/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render;

import io.themade4.relictium.Relictium;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gl.compat.FogHelper;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.oneshot.ChunkRenderBackendOneshot;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheShared;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import me.jellysquid.mods.sodium.common.util.ListUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;

public class SodiumWorldRenderer
implements ChunkStatusListener {
    private static SodiumWorldRenderer instance;
    private final Minecraft client;
    private WorldClient world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private float lastFogDistance;
    private boolean useEntityCulling;
    private final LongSet loadedChunkPositions = new LongOpenHashSet();
    private final Set<TileEntity> globalBlockEntities = new ObjectOpenHashSet();
    private Frustum frustum;
    private ChunkRenderManager<?> chunkRenderManager;
    private BlockRenderPassManager renderPassManager;
    private ChunkRenderBackend<?> chunkRenderBackend;
    public static boolean hasChanges;

    public static SodiumWorldRenderer create() {
        if (instance == null) {
            instance = new SodiumWorldRenderer(Minecraft.func_71410_x());
        }
        return instance;
    }

    @Deprecated
    public static SodiumWorldRenderer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Renderer not initialized");
        }
        return instance;
    }

    public static SodiumWorldRenderer getInstanceNullable() {
        return instance;
    }

    private SodiumWorldRenderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(WorldClient world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(WorldClient world) {
        this.world = world;
        ChunkRenderCacheShared.createRenderContext(this.world);
        this.initRenderer();
        ((ChunkStatusListenerManager)world.func_72863_F()).setListener(this);
    }

    private void unloadWorld() {
        ChunkRenderCacheShared.destroyRenderContext(this.world);
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.loadedChunkPositions.clear();
        this.globalBlockEntities.clear();
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.markDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.chunkRenderManager.isBuildComplete();
    }

    public void updateChunks(Frustum frustum, float ticks, boolean hasForcedFrustum, int frame, boolean spectator) {
        boolean dirty;
        this.frustum = frustum;
        this.useEntityCulling = Relictium.options().advanced.useEntityCulling;
        if (this.client.field_71474_y.field_151451_c != this.renderDistance) {
            this.reload();
        }
        Profiler profiler = this.client.field_71424_I;
        profiler.func_76320_a("camera_setup");
        Entity viewEntity = this.client.func_175606_aa();
        if (viewEntity == null) {
            throw new IllegalStateException("Client instance has no active render entity");
        }
        double x = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * (double)ticks;
        double y = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * (double)ticks + (double)viewEntity.func_70047_e();
        double z = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * (double)ticks;
        this.chunkRenderManager.setCameraPosition(x, y, z);
        float fogDistance = FogHelper.getFogCutoff();
        boolean bl = x != this.lastCameraX || y != this.lastCameraY || z != this.lastCameraZ || (double)viewEntity.field_70125_A != this.lastCameraPitch | (double)viewEntity.field_70177_z != this.lastCameraYaw ? true : (dirty = false);
        if (dirty) {
            this.chunkRenderManager.markDirty();
        }
        this.lastCameraX = x;
        this.lastCameraY = y;
        this.lastCameraZ = z;
        this.lastCameraPitch = viewEntity.field_70125_A;
        this.lastCameraYaw = viewEntity.field_70177_z;
        this.lastFogDistance = fogDistance;
        profiler.func_76318_c("chunk_update");
        this.chunkRenderManager.updateChunks();
        if (!hasForcedFrustum && this.chunkRenderManager.isDirty()) {
            profiler.func_76318_c("chunk_graph_rebuild");
            this.chunkRenderManager.update(ticks, (FrustumExtended)frustum, frame, spectator);
        }
        profiler.func_76318_c("visible_chunk_tick");
        this.chunkRenderManager.tickVisibleRenders();
        profiler.func_76319_b();
        Entity.func_184227_b((double)(MathHelper.func_151237_a((double)((double)this.client.field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5) * 2000.0));
    }

    public void drawChunkLayer(BlockRenderLayer renderLayer, double x, double y, double z) {
        BlockRenderPass pass = this.renderPassManager.getRenderPassForLayer(renderLayer);
        this.chunkRenderManager.renderLayer(pass, x, y, z);
        GlStateManager.func_179117_G();
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        this.initRenderer();
    }

    private void initRenderer() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.globalBlockEntities.clear();
        RenderDevice device = RenderDevice.INSTANCE;
        this.renderDistance = this.client.field_71474_y.field_151451_c;
        SodiumGameOptions opts = Relictium.options();
        this.renderPassManager = BlockRenderPassManager.createDefaultMappings();
        ChunkVertexType vertexFormat = opts.advanced.useCompactVertexFormat ? DefaultModelVertexFormats.MODEL_VERTEX_HFP : DefaultModelVertexFormats.MODEL_VERTEX_SFP;
        this.chunkRenderBackend = SodiumWorldRenderer.createChunkRenderBackend(device, opts, vertexFormat);
        this.chunkRenderBackend.createShaders(device);
        this.chunkRenderManager = new ChunkRenderManager(this, this.chunkRenderBackend, this.renderPassManager, this.world, this.renderDistance);
        this.chunkRenderManager.restoreChunks((LongCollection)this.loadedChunkPositions);
    }

    private static ChunkRenderBackend<?> createChunkRenderBackend(RenderDevice device, SodiumGameOptions options, ChunkVertexType vertexFormat) {
        boolean disableBlacklist = Relictium.options().advanced.ignoreDriverBlacklist;
        if (options.advanced.useChunkMultidraw && MultidrawChunkRenderBackend.isSupported(disableBlacklist)) {
            return new MultidrawChunkRenderBackend(device, vertexFormat);
        }
        return new ChunkRenderBackendOneshot(vertexFormat);
    }

    private boolean checkBEVisibility(TileEntity entity) {
        return this.frustum.func_78546_a(entity.getRenderBoundingBox());
    }

    private void renderTE(TileEntity tileEntity, int pass, float partialTicks, int damageProgress) {
        if (damageProgress < 0 && !tileEntity.shouldRenderInPass(pass) || !this.checkBEVisibility(tileEntity)) {
            return;
        }
        try {
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, damageProgress);
        }
        catch (RuntimeException e) {
            if (tileEntity.func_145837_r()) {
                Relictium.logger().error("Suppressing crash from invalid tile entity", (Throwable)e);
            }
            throw e;
        }
    }

    private void preRenderDamagedBlocks() {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-1.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
    }

    private void postRenderDamagedBlocks() {
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void renderTileEntities(float partialTicks, Map<Integer, DestroyBlockProgress> damagedBlocks) {
        int pass = MinecraftForgeClient.getRenderPass();
        TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
        for (TileEntity tileEntity : this.chunkRenderManager.getVisibleBlockEntities()) {
            this.renderTE(tileEntity, pass, partialTicks, -1);
        }
        for (TileEntity tileEntity : this.globalBlockEntities) {
            this.renderTE(tileEntity, pass, partialTicks, -1);
        }
        TileEntityRendererDispatcher.field_147556_a.drawBatch(pass);
        this.preRenderDamagedBlocks();
        for (DestroyBlockProgress destroyProgress : damagedBlocks.values()) {
            BlockPos pos = destroyProgress.func_180246_b();
            if (!this.world.func_180495_p(pos).func_177230_c().func_149716_u()) continue;
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityChest) {
                TileEntityChest chest = (TileEntityChest)tileEntity;
                if (chest.field_145991_k != null) {
                    pos = pos.func_177972_a(EnumFacing.WEST);
                    tileEntity = this.world.func_175625_s(pos);
                } else if (chest.field_145992_i != null) {
                    pos = pos.func_177972_a(EnumFacing.NORTH);
                    tileEntity = this.world.func_175625_s(pos);
                }
            }
            IBlockState state = this.world.func_180495_p(pos);
            if (tileEntity == null || !state.func_191057_i()) continue;
            this.renderTE(tileEntity, pass, partialTicks, destroyProgress.func_73106_e());
        }
        this.postRenderDamagedBlocks();
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadedChunkPositions.add(ChunkPos.func_77272_a((int)x, (int)z));
        this.chunkRenderManager.onChunkAdded(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.loadedChunkPositions.remove(ChunkPos.func_77272_a((int)x, (int)z));
        this.chunkRenderManager.onChunkRemoved(x, z);
    }

    public void onChunkRenderUpdated(int x, int y, int z, ChunkRenderData meshBefore, ChunkRenderData meshAfter) {
        ListUtil.updateList(this.globalBlockEntities, meshBefore.getGlobalBlockEntities(), meshAfter.getGlobalBlockEntities());
        this.chunkRenderManager.onChunkRenderUpdates(x, y, z, meshAfter);
    }

    private static boolean isInfiniteExtentsBox(AxisAlignedBB box) {
        return Double.isInfinite(box.field_72340_a) || Double.isInfinite(box.field_72338_b) || Double.isInfinite(box.field_72339_c) || Double.isInfinite(box.field_72336_d) || Double.isInfinite(box.field_72337_e) || Double.isInfinite(box.field_72334_f);
    }

    public boolean isEntityVisible(Entity entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        AxisAlignedBB box = entity.func_184177_bl();
        if (box.field_72337_e < 0.5 || box.field_72338_b > 255.5) {
            return true;
        }
        if (SodiumWorldRenderer.isInfiniteExtentsBox(box)) {
            return true;
        }
        if (entity.func_184202_aL() || entity.func_94059_bO()) {
            return true;
        }
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 0.5)) >> 4;
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 0.5)) >> 4;
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 0.5)) >> 4;
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 0.5)) >> 4;
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 0.5)) >> 4;
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 0.5)) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.chunkRenderManager.isChunkVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Frustum getFrustum() {
        return this.frustum;
    }

    public String getChunksDebugString() {
        return String.format("C: %s/%s Q: %s+%si ", this.chunkRenderManager.getVisibleChunkCount(), this.chunkRenderManager.getTotalSections(), this.chunkRenderManager.getRebuildQueueSize(), this.chunkRenderManager.getImportantRebuildQueueSize());
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.chunkRenderManager.scheduleRebuild(x, y, z, important);
    }

    public ChunkRenderBackend<?> getChunkRenderer() {
        return this.chunkRenderBackend;
    }

    static {
        hasChanges = false;
    }
}

