/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.data;

import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class LightDataAccess {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected WorldSlice world;

    public long get(int x, int y, int z, EnumFacing d1, EnumFacing d2) {
        return this.get(x + d1.func_82601_c() + d2.func_82601_c(), y + d1.func_96559_d() + d2.func_96559_d(), z + d1.func_82599_e() + d2.func_82599_e());
    }

    public long get(int x, int y, int z, EnumFacing dir) {
        return this.get(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
    }

    public long get(BlockPos pos, EnumFacing dir) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dir);
    }

    public long get(BlockPos pos) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public abstract long get(int var1, int var2, int var3);

    protected long compute(int x, int y, int z) {
        boolean em;
        float ao;
        WorldSlice world = this.world;
        BlockPos.MutableBlockPos pos = this.pos.func_181079_c(x, y, z);
        IBlockState state = world.func_180495_p((BlockPos)pos);
        if (state.getLightValue((IBlockAccess)world, (BlockPos)pos) == 0) {
            ao = state.func_185892_j();
            em = false;
        } else {
            ao = 1.0f;
            em = true;
        }
        boolean op = state.func_185895_e() || state.getLightOpacity((IBlockAccess)world, (BlockPos)pos) == 0;
        boolean fo = state.func_185914_p();
        boolean fc = state.func_185917_h();
        int lm = fo && !em ? 0 : state.func_185889_a((IBlockAccess)world, (BlockPos)pos);
        return LightDataAccess.packAO(ao) | LightDataAccess.packLM(lm) | LightDataAccess.packOP(op) | LightDataAccess.packFO(fo) | LightDataAccess.packFC(fc) | 0x1000000000000000L;
    }

    public static long packOP(boolean opaque) {
        return (opaque ? 1L : 0L) << 56;
    }

    public static boolean unpackOP(long word) {
        return (word >>> 56 & 1L) != 0L;
    }

    public static long packFO(boolean opaque) {
        return (opaque ? 1L : 0L) << 57;
    }

    public static boolean unpackFO(long word) {
        return (word >>> 57 & 1L) != 0L;
    }

    public static long packFC(boolean fullCube) {
        return (fullCube ? 1L : 0L) << 58;
    }

    public static boolean unpackFC(long word) {
        return (word >>> 58 & 1L) != 0L;
    }

    public static long packLM(int lm) {
        return (long)lm & 0xFFFFFFFFL;
    }

    public static int unpackLM(long word) {
        return (int)(word & 0xFFFFFFFFL);
    }

    public static long packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return ((long)aoi & 0xFFFFL) << 32;
    }

    public static float unpackAO(long word) {
        int aoi = (int)(word >>> 32 & 0xFFFFL);
        return (float)aoi * 2.4414062E-4f;
    }

    public WorldSlice getWorld() {
        return this.world;
    }
}

