/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light;

import me.jellysquid.mods.sodium.client.util.MathUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

public class EntityLighter {
    private static final double MIN_BOX_SIZE = 0.001;
    private static final double MAX_LIGHT_VAL = 15.0;
    private static final double MAX_LIGHTMAP_COORD = 240.0;

    public static int getBlendedLight(Entity entity, float tickDelta) {
        boolean calcBlockLight = !entity.func_70027_ad();
        double x1 = MathUtil.lerp(tickDelta, entity.field_70169_q, entity.field_70165_t);
        double y1 = MathUtil.lerp(tickDelta, entity.field_70167_r, entity.field_70163_u);
        double z1 = MathUtil.lerp(tickDelta, entity.field_70166_s, entity.field_70161_v);
        double width = Math.max((double)entity.field_70130_N, 0.001);
        double height = Math.max((double)entity.field_70131_O, 0.001);
        double x2 = x1 + width;
        double y2 = y1 + height;
        double z2 = z1 + width;
        int bMinX = MathHelper.func_76128_c((double)x1);
        int bMinY = MathHelper.func_76128_c((double)y1);
        int bMinZ = MathHelper.func_76128_c((double)z1);
        int bMaxX = MathHelper.func_76143_f((double)x2);
        int bMaxY = MathHelper.func_76143_f((double)y2);
        int bMaxZ = MathHelper.func_76143_f((double)z2);
        double max = 0.0;
        double sl = 0.0;
        double bl = 0.0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int bX = bMinX; bX < bMaxX; ++bX) {
            double ix1 = Math.max((double)bX, x1);
            double ix2 = Math.min((double)(bX + 1), x2);
            for (int bY = bMinY; bY < bMaxY; ++bY) {
                double iy1 = Math.max((double)bY, y1);
                double iy2 = Math.min((double)(bY + 1), y2);
                for (int bZ = bMinZ; bZ < bMaxZ; ++bZ) {
                    pos.func_181079_c(bX, bY, bZ);
                    IBlockState blockState = entity.field_70170_p.func_180495_p((BlockPos)pos);
                    if (blockState.func_185914_p() && blockState.getLightValue((IBlockAccess)entity.field_70170_p, (BlockPos)pos) <= 0) continue;
                    double iz1 = Math.max((double)bZ, z1);
                    double iz2 = Math.min((double)(bZ + 1), z2);
                    double weight = (ix2 - ix1) * (iy2 - iy1) * (iz2 - iz1);
                    max += weight;
                    sl += weight * ((double)entity.field_70170_p.func_175642_b(EnumSkyBlock.SKY, (BlockPos)pos) / 15.0);
                    if (calcBlockLight) {
                        bl += weight * ((double)entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)pos) / 15.0);
                        continue;
                    }
                    bl += weight;
                }
            }
        }
        int bli = MathHelper.func_76128_c((double)(bl / max * 240.0));
        int sli = MathHelper.func_76128_c((double)(sl / max * 240.0));
        return (sli & 0xFFFF) << 16 | bli & 0xFFFF;
    }
}

