/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.gui.options.FormattedTextProvider;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.named.NamedState;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.Validate;

public class CyclingControl<T extends Enum<T>>
implements Control<T> {
    private final Option<T> option;
    private final T[] allowedValues;
    private final ITextComponent[] names;

    public CyclingControl(Option<T> option, Class<T> enumType) {
        this(option, enumType, (Enum[])enumType.getEnumConstants());
    }

    public CyclingControl(Option<T> option, Class<T> enumType, ITextComponent[] names) {
        Object[] universe = (Enum[])enumType.getEnumConstants();
        Validate.isTrue((universe.length == names.length ? 1 : 0) != 0, (String)"Mismatch between universe length and names array length", (Object[])new Object[0]);
        Validate.notEmpty((Object[])universe, (String)"The enum universe must contain at least one item", (Object[])new Object[0]);
        this.option = option;
        this.allowedValues = universe;
        this.names = names;
    }

    @Deprecated
    public CyclingControl(Option<T> option, Class<T> enumType, String[] names) {
        this(option, enumType, (ITextComponent[])Arrays.stream(names).map(TextComponentString::new).toArray(ITextComponent[]::new));
    }

    public CyclingControl(Option<T> option, Class<T> enumType, T[] allowedValues) {
        Enum[] universe = (Enum[])enumType.getEnumConstants();
        this.option = option;
        this.allowedValues = allowedValues;
        this.names = new ITextComponent[universe.length];
        for (int i = 0; i < this.names.length; ++i) {
            Enum value = universe[i];
            Object name = value instanceof TextProvider ? new TextComponentString(((TextProvider)((Object)value)).getLocalizedName()) : (value instanceof FormattedTextProvider ? ((FormattedTextProvider)((Object)value)).getLocalizedName() : (value instanceof NamedState ? new TextComponentTranslation(((NamedState)((Object)value)).getKey(), new Object[0]) : new TextComponentString(value.name())));
            this.names[i] = name;
        }
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    @Override
    public ControlElement<T> createElement(Dim2i dim) {
        return new CyclingControlElement(this.option, dim, this.allowedValues, this.names);
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    private static class CyclingControlElement<T extends Enum<T>>
    extends ControlElement<T> {
        private final T[] allowedValues;
        private final ITextComponent[] names;
        private int currentIndex;

        public CyclingControlElement(Option<T> option, Dim2i dim, T[] allowedValues, ITextComponent[] names) {
            super(option, dim);
            this.allowedValues = allowedValues;
            this.names = names;
            this.currentIndex = 0;
            for (int i = 0; i < allowedValues.length; ++i) {
                if (allowedValues[i] != option.getValue()) continue;
                this.currentIndex = i;
                break;
            }
        }

        @Override
        public void render(int mouseX, int mouseY, float delta) {
            super.render(mouseX, mouseY, delta);
            Enum value = (Enum)this.option.getValue();
            ITextComponent name = this.names[value.ordinal()];
            int strWidth = this.getTextWidth(name);
            this.drawString(name.func_150254_d(), this.dim.getLimitX() - strWidth - 6, this.dim.getCenterY() - 4, -1);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.currentIndex = (((Enum)this.option.getValue()).ordinal() + 1) % this.allowedValues.length;
                this.option.setValue(this.allowedValues[this.currentIndex]);
                this.playClickSound();
                return true;
            }
            return false;
        }
    }
}

