/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import io.themade4.relictium.Relictium;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.URLUtils;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.utils.Drawable;
import me.jellysquid.mods.sodium.client.gui.utils.Element;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class SodiumOptionsGUI
extends GuiScreen {
    private final List<Element> children = new CopyOnWriteArrayList<Element>();
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    private final List<Drawable> drawable = new ArrayList<Drawable>();
    public final GuiScreen prevScreen;
    private OptionPage currentPage;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private ControlElement<?> hoveredElement;

    public SodiumOptionsGUI(GuiScreen prevScreen) {
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.pages.add(SodiumGameOptionPages.performance());
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.rebuildGUI();
    }

    private void rebuildGUI() {
        this.controls.clear();
        this.children.clear();
        this.drawable.clear();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 211, this.field_146295_m - 26, 65, 20), new TextComponentTranslation("relictium.options.buttons.undo", new Object[0]).func_150254_d(), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 142, this.field_146295_m - 26, 65, 20), new TextComponentTranslation("relictium.options.buttons.apply", new Object[0]).func_150254_d(), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 73, this.field_146295_m - 26, 65, 20), new TextComponentTranslation("gui.done", new Object[0]).func_150254_d(), this::onClose);
        this.donateButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 128, 6, 100, 20), new TextComponentTranslation("relictium.options.buttons.donate", new Object[0]).func_150254_d(), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(new Dim2i(this.field_146294_l - 26, 6, 20, 20), "x", this::hideDonationButton);
        if (Relictium.options().notifications.hideDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        this.children.add(this.undoButton);
        this.children.add(this.applyButton);
        this.children.add(this.closeButton);
        this.children.add(this.donateButton);
        this.children.add(this.hideDonateButton);
        for (Element element : this.children) {
            if (!(element instanceof Drawable)) continue;
            this.drawable.add((Drawable)((Object)element));
        }
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = Relictium.options();
        options.notifications.hideDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.field_146289_q.func_78256_a(page.getNewName().func_150254_d());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 18), page.getNewName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.children.add(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 200, 18));
                this.controls.add(element);
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        super.func_146276_q_();
        this.updateControls();
        for (Drawable drawable : this.drawable) {
            drawable.render(mouseX, mouseY, delta);
        }
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(this.hoveredElement);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(ControlElement::isHovered).findFirst().orElse(null);
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.getOriginY();
        int boxX = dim.getLimitX() + boxPadding;
        Option<?> option = element.getOption();
        ArrayList<String> tooltip = new ArrayList<String>(this.field_146289_q.func_78271_c(option.getTooltip().func_150254_d(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"relictium.options.performance_impact_string", (Object[])new Object[]{impact.toDisplayString()}));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.field_146295_m - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.func_73733_a(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.field_146289_q.func_78276_b((String)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            this.field_146297_k.field_71438_f.func_72712_a();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            this.field_146297_k.func_147117_R().func_147633_a(this.field_146297_k.field_71474_y.field_151442_I);
            this.field_146297_k.func_110436_a();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private void openDonationPage() {
        URLUtils.open("https://caffeinemc.net/donate");
    }

    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 && !this.shouldCloseOnEsc()) {
            return;
        }
        if (keyCode == 1) {
            this.onClose();
            return;
        }
        if (keyCode == 25 && SodiumOptionsGUI.func_146272_n()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiVideoSettings(this.prevScreen, this.field_146297_k.field_71474_y));
        }
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    public void onClose() {
        this.field_146297_k.func_147108_a(this.prevScreen);
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.children.forEach(element -> element.mouseClicked(mouseX, mouseY, mouseButton));
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.children.forEach(element -> element.mouseDragged(mouseX, mouseY));
    }
}

