/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.named.AttackIndicator;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsMode;
import me.jellysquid.mods.sodium.client.gui.options.named.ParticleMode;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.opengl.Display;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.renderDistance", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.view_distance.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.quantity("options.chunks"))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.gamma", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.brightness.tooltip", new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (float)value.intValue() * 0.01f;
        }, opts -> (int)(opts.field_74333_Y / 0.01f)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.clouds.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.clouds.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableClouds = value;
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.guiScale", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.gui_scale.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 3, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
            if (Minecraft.func_71410_x().field_71462_r instanceof SodiumOptionsGUI) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new SodiumOptionsGUI(((SodiumOptionsGUI)Minecraft.func_71410_x().field_71462_r).prevScreen));
            }
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.fullscreen", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.fullscreen.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            if (client.func_71372_G() != opts.field_74353_u) {
                client.func_71352_k();
                opts.field_74353_u = client.func_71372_G();
            }
        }, opts -> opts.field_74353_u).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.vsync", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.v_sync.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74352_v = value;
            Display.setVSyncEnabled((boolean)opts.field_74352_v);
        }, opts -> opts.field_74352_v).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.framerateLimit", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.fps_limit.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
        }, opts -> opts.field_74350_i).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.viewBobbing", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.view_bobbing.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74336_f = value;
        }, opts -> opts.field_74336_f).build()).add(OptionImpl.createBuilder(AttackIndicator.class, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.attackIndicator", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.attack_indicator.tooltip", new Object[0])).setControl(opts -> new CyclingControl<AttackIndicator>((Option<AttackIndicator>)opts, AttackIndicator.class, new ITextComponent[]{new TextComponentTranslation(AttackIndicator.OFF.getTranslationKey(), new Object[0]), new TextComponentTranslation(AttackIndicator.CROSSHAIR.getTranslationKey(), new Object[0]), new TextComponentTranslation(AttackIndicator.HOTBAR.getTranslationKey(), new Object[0])})).setBinding((opts, value) -> {
            opts.field_186716_M = value.getId();
        }, opts -> AttackIndicator.byId(opts.field_186716_M)).build()).build());
        return new OptionPage((ITextComponent)new TextComponentTranslation("stat.generalButton", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsMode.class, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.graphics", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.graphics_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<GraphicsMode>((Option<GraphicsMode>)option, GraphicsMode.class)).setBinding((opts, value) -> {
            opts.field_74347_j = value.isFancy();
        }, opts -> GraphicsMode.fromBoolean(opts.field_74347_j)).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("options.renderClouds", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.clouds_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.cloudQuality = value;
        }, opts -> opts.quality.cloudQuality).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("soundCategory.weather", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.weather_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.leaves_quality.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.leaves_quality.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleMode.class, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.particles", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.particle_quality.tooltip", new Object[0])).setControl(opt -> new CyclingControl<ParticleMode>((Option<ParticleMode>)opt, ParticleMode.class)).setBinding((opts, value) -> {
            opts.field_74362_aa = value.ordinal();
        }, opts -> ParticleMode.fromOrdinal(opts.field_74362_aa)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.LightingQuality.class, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("options.ao", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.smooth_lighting.tooltip", new Object[0])).setControl(option -> new CyclingControl<SodiumGameOptions.LightingQuality>((Option<SodiumGameOptions.LightingQuality>)option, SodiumGameOptions.LightingQuality.class)).setBinding((opts, value) -> {
            opts.quality.smoothLighting = value;
        }, opts -> opts.quality.smoothLighting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.biome_blend.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.biome_blend.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.quantityOrDisabled("relictium.options.biome_blend.value", "gui.none"))).setBinding((opts, value) -> {
            opts.quality.biomeBlendRadius = value;
        }, opts -> opts.quality.biomeBlendRadius).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.entity_distance.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.entity_distance.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.quality.entityDistanceScaling = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.quality.entityDistanceScaling * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.entityShadows", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.entity_shadows.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_181151_V = value;
        }, opts -> opts.field_181151_V).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.vignette.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.vignette.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((ITextComponent)new TextComponentTranslation("options.mipmapLevels", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.mipmap_levels.tooltip", new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((ITextComponent)new TextComponentTranslation("relictium.options.pages.quality", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_chunk_multidraw.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_chunk_multidraw.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useChunkMultidraw = value;
        }, opts -> opts.advanced.useChunkMultidraw).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.EXTREME).setEnabled(MultidrawChunkRenderBackend.isSupported(SodiumGameOptionPages.sodiumOpts.getData().advanced.ignoreDriverBlacklist)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_vertex_objects.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_vertex_objects.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useVertexArrayObjects = value;
        }, opts -> opts.advanced.useVertexArrayObjects).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_block_face_culling.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_block_face_culling.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useBlockFaceCulling = value;
        }, opts -> opts.advanced.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_compact_vertex_format.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_compact_vertex_format.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useCompactVertexFormat = value;
        }, opts -> opts.advanced.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_fog_occlusion.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_fog_occlusion.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.translucency_sorting.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.translucency_sorting.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.translucencySorting = value;
        }, opts -> opts.advanced.translucencySorting).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_entity_culling.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_entity_culling.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useEntityCulling = value;
        }, opts -> opts.advanced.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.use_particle_culling.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.use_particle_culling.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.LOW).setBinding((opts, value) -> {
            opts.advanced.useParticleCulling = value;
        }, opts -> opts.advanced.useParticleCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.animate_only_visible_textures.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.animate_only_visible_textures.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.allow_direct_memory_access.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.allow_direct_memory_access.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.ignore_driver_blacklist.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.ignore_driver_blacklist.tooltip", new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.ignoreDriverBlacklist = value;
        }, opts -> opts.advanced.ignoreDriverBlacklist).build()).build());
        return new OptionPage((ITextComponent)new TextComponentTranslation("relictium.options.pages.advanced", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.chunk_update_threads.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.chunk_update_threads.tooltip", new Object[0])).setControl(o -> new SliderControl((Option<Integer>)o, 0, Runtime.getRuntime().availableProcessors(), 1, ControlValueFormatter.quantityOrDisabled("relictium.options.threads.value", "relictium.options.default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((ITextComponent)new TextComponentTranslation("relictium.options.always_defer_chunk_updates.name", new Object[0])).setTooltip((ITextComponent)new TextComponentTranslation("relictium.options.always_defer_chunk_updates.tooltip", new Object[0])).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage((ITextComponent)new TextComponentTranslation("relictium.options.pages.performance", new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

