/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomePrismarine
extends BasicUndergroundBiome {
    public static double seaLanternChance;
    public static double waterChance;
    private IBlockState lanternState = Blocks.field_180398_cJ.func_176223_P();
    public static boolean spawnElderPrismarine;

    public UndergroundBiomePrismarine() {
        super(Blocks.field_180397_cI.func_176223_P(), Blocks.field_180397_cI.func_176223_P(), Blocks.field_180397_cI.func_176223_P());
    }

    public void update() {
        IBlockState prismarineState;
        boolean elder = UndergroundBiomes.elderPrismarineEnabled && spawnElderPrismarine;
        this.floorState = this.wallState = (prismarineState = (elder ? UndergroundBiomes.elder_prismarine : Blocks.field_180397_cI).func_176223_P());
        this.ceilingState = this.wallState;
        this.lanternState = (elder ? UndergroundBiomes.elder_sea_lantern : Blocks.field_180398_cJ).func_176223_P();
    }

    @Override
    public void fillWall(World world, BlockPos pos, IBlockState state) {
        super.fillWall(world, pos, state);
        if (world.field_73012_v.nextDouble() < seaLanternChance) {
            world.func_180501_a(pos, this.lanternState, 2);
        }
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        if (world.field_73012_v.nextDouble() < waterChance && !this.isBorder(world, pos)) {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        } else {
            super.fillFloor(world, pos, state);
        }
    }

    @Override
    public void setupConfig(String category) {
        seaLanternChance = ConfigHelper.loadLegacyPropChance("Sea Lantern Percentage Chance", category, "Sea Lantern Chance", "The chance sea lanterns will spawn", 0.0085);
        waterChance = ConfigHelper.loadLegacyPropChance("Water Percentage Chance", category, "Water Chance", "The chance water will spawn", 0.25);
        spawnElderPrismarine = ModuleLoader.config.getBoolean("Spawn Elder Prismarine", category, true, "Set to false to spawn regular prismarine instead of elder prismarine (even if the block is enabled)");
    }
}

