/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.handler.RayTraceHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.block.BlockGlowstoneDust;
import vazkii.quark.misc.block.BlockGunpowder;

public class PlaceVanillaDusts
extends Feature {
    public static Block glowstone_dust_block;
    public static Block gunpowder_block;
    public static boolean enableGlowstone;
    public static boolean enableGunpowder;
    public static int gunpowderDelay;
    public static int gunpowderDelayNetherrack;

    @Override
    public void setupConfig() {
        enableGlowstone = this.loadPropBool("Enable Glowstone", "", true);
        enableGunpowder = this.loadPropBool("Enable Gunpowder", "", true);
        gunpowderDelay = this.loadPropInt("Gunpowder Delay", "Amount of ticks between each piece of gunpowder igniting the next", 10);
        gunpowderDelayNetherrack = this.loadPropInt("Gunpowder Delay on Netherrack", "Amount of ticks between each piece of gunpowder igniting the next, if on Netherrack", 5);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableGlowstone) {
            glowstone_dust_block = new BlockGlowstoneDust();
        }
        if (enableGunpowder) {
            gunpowder_block = new BlockGunpowder();
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        EnumHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        RayTraceResult res = RayTraceHandler.rayTrace(world, player, false);
        if (res != null) {
            BlockPos pos = res.func_178782_a();
            EnumFacing face = res.field_178784_b;
            if (enableGlowstone && stack.func_77973_b() == Items.field_151114_aO) {
                PlaceVanillaDusts.setBlock((PlayerInteractEvent)event, player, stack, world, pos, hand, face, glowstone_dust_block, res);
            } else if (enableGunpowder && stack.func_77973_b() == Items.field_151016_H) {
                PlaceVanillaDusts.setBlock((PlayerInteractEvent)event, player, stack, world, pos, hand, face, gunpowder_block, res);
            }
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("glowstone_dust_block") && !mapping.key.func_110623_a().equals("gunpowder_block")) continue;
            mapping.ignore();
        }
    }

    public static void setBlock(PlayerInteractEvent event, EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, Block block, RayTraceResult res) {
        ItemStack itemstack;
        boolean flag = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockpos = flag ? pos : pos.func_177972_a(facing);
        if (player.func_175151_a(blockpos, facing, itemstack = player.func_184586_b(hand)) && worldIn.func_190527_a(worldIn.func_180495_p(blockpos).func_177230_c(), blockpos, false, facing, null) && block.func_176196_c(worldIn, blockpos)) {
            float hx = (float)(res.field_72307_f.field_72450_a - (double)blockpos.func_177958_n());
            float hy = (float)(res.field_72307_f.field_72448_b - (double)blockpos.func_177956_o());
            float hz = (float)(res.field_72307_f.field_72449_c - (double)blockpos.func_177952_p());
            IBlockState state = block.func_180642_a(worldIn, blockpos, facing, hx, hy, hz, stack.func_77960_j(), (EntityLivingBase)player);
            worldIn.func_175656_a(blockpos, state);
            SoundType soundtype = state.func_177230_c().getSoundType(state, worldIn, pos, (Entity)player);
            worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, blockpos, itemstack);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            player.func_184609_a(hand);
        }
        event.setCanceled(true);
        event.setCancellationResult(flag ? EnumActionResult.SUCCESS : EnumActionResult.FAIL);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

