/*
 * Decompiled with CFR 0.152.
 */
package baubles.core.transformers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;

public class BaseTransformer
implements Opcodes {
    protected static String getName(String mcpName, String srgName) {
        return FMLLaunchHandler.isDeobfuscatedEnvironment() ? mcpName : srgName;
    }

    protected static ClassNode read(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode cls = new ClassNode();
        reader.accept((ClassVisitor)cls, 0);
        return cls;
    }

    protected static byte[] write(ClassNode cls) {
        return BaseTransformer.write(cls, 1);
    }

    protected static byte[] write(ClassNode cls, int options) {
        ClassWriter writer = new ClassWriter(options);
        cls.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    protected static void writeClass(ClassNode cls) {
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            return;
        }
        File file = new File("classOut/" + cls.name + ".class");
        file.getParentFile().mkdirs();
        try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ClassWriter writer = new ClassWriter(1);
            cls.accept((ClassVisitor)writer);
            stream.write(writer.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

