/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.container;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SlotBauble
extends SlotItemHandler {
    private final int slotIndex;
    private final IBaublesItemHandler baublesHandler;
    private final EntityPlayer player;

    public SlotBauble(EntityPlayer player, IBaublesItemHandler itemHandler, int slot, int par4, int par5) {
        super((IItemHandler)itemHandler, slot, par4, par5);
        this.baublesHandler = itemHandler;
        this.player = player;
        this.slotIndex = slot;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
        return bauble != null && this.baublesHandler.isItemValidForSlot(this.slotIndex, stack, (EntityLivingBase)this.player);
    }

    public boolean func_82869_a(@Nonnull EntityPlayer player) {
        ItemStack stack = this.func_75211_c();
        if (stack.func_190926_b()) {
            return false;
        }
        int binding = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack);
        if (!player.func_184812_l_() && binding > 0) {
            return false;
        }
        IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
        return bauble == null || bauble.canUnequip(stack, (EntityLivingBase)player);
    }

    @Nonnull
    public ItemStack func_190901_a(@Nonnull EntityPlayer playerIn, @Nonnull ItemStack stack) {
        IBauble bauble;
        if (!stack.func_190926_b() && !this.baublesHandler.isEventBlocked() && (bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) != null) {
            bauble.onUnequipped(stack, (EntityLivingBase)playerIn);
        }
        return super.func_190901_a(playerIn, stack);
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        if (this.func_75216_d() && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.func_75211_c()) && !((IBaublesItemHandler)this.getItemHandler()).isEventBlocked() && this.func_75211_c().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            ((IBauble)this.func_75211_c().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)).onUnequipped(this.func_75211_c(), (EntityLivingBase)this.player);
        }
        ItemStack oldstack = this.func_75211_c().func_77946_l();
        super.func_75215_d(stack);
        if (this.func_75216_d() && !ItemStack.func_77989_b((ItemStack)oldstack, (ItemStack)this.func_75211_c()) && !((IBaublesItemHandler)this.getItemHandler()).isEventBlocked() && this.func_75211_c().hasCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null)) {
            ((IBauble)Objects.requireNonNull(this.func_75211_c().getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null))).onEquipped(this.func_75211_c(), (EntityLivingBase)this.player);
        }
    }

    @Nullable
    public String func_178171_c() {
        return ((BaublesContainer)this.baublesHandler).getSlot(this.slotIndex).getBackgroundTexture(this.slotIndex);
    }

    public int func_75219_a() {
        return 64;
    }
}

