/*
 * Decompiled with CFR 0.152.
 */
package baubles.common;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.BaubleItem;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.CommonProxy;
import baubles.common.Config;
import baubles.common.event.CommandBaubles;
import baubles.common.integration.ModCompatibility;
import baubles.common.network.PacketHandler;
import java.io.File;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="baubles", name="Baubles", version="2.2", guiFactory="baubles.client.gui.BaublesGuiFactory")
public class Baubles {
    public static final String MODID = "baubles";
    public static final Logger log = LogManager.getLogger((String)"baubles".toUpperCase());
    public static final int GUI = 0;
    @SidedProxy(clientSide="baubles.client.ClientProxy", serverSide="baubles.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="baubles")
    public static Baubles instance;
    public File modDir;
    public static final Item MAX_VERSTAPPEN;
    public static final SoundEvent TU_TU_TU_TU;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modDir = event.getModConfigurationDirectory();
        Config.initialize(event.getSuggestedConfigurationFile());
        CapabilityManager.INSTANCE.register(IBaublesItemHandler.class, new BaublesCapabilities.CapabilityBaubles(), BaublesContainer::new);
        CapabilityManager.INSTANCE.register(IBauble.class, (Capability.IStorage)new BaublesCapabilities.CapabilityItemBaubleStorage(), () -> new BaubleItem(BaubleType.TRINKET));
        proxy.registerEventHandlers();
        PacketHandler.init();
        ModCompatibility.applyEvents();
        Config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.init();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBaubles());
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)MAX_VERSTAPPEN);
    }

    @SubscribeEvent
    public void registerSound(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)TU_TU_TU_TU);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModel(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)MAX_VERSTAPPEN, (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(MAX_VERSTAPPEN.getRegistryName()), "inventory"));
    }

    static {
        ResourceLocation MAX_VERSTAPPEN_LOCATION = new ResourceLocation(MODID, "max_verstappen");
        MAX_VERSTAPPEN = ((Item)new BaubleItem(BaubleType.RING){

            @Override
            public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
                World world = player.field_70170_p;
                if (!world.field_72995_K) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TU_TU_TU_TU, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }.setRegistryName(MAX_VERSTAPPEN_LOCATION)).func_77655_b("baubles.max_verstappen").func_77637_a(CreativeTabs.field_78026_f);
        TU_TU_TU_TU = (SoundEvent)new SoundEvent(MAX_VERSTAPPEN_LOCATION).setRegistryName(MAX_VERSTAPPEN_LOCATION);
    }
}

