/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.config;

import com.brandon3055.brandonscore.client.gui.config.BCGuiConfigEntries;
import com.brandon3055.brandonscore.registry.ModConfigParser;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Keyboard;

public class BCModConfigGui
extends GuiConfig {
    public BCModConfigGui(GuiScreen parent, ModContainer mod) {
        super(parent, BCModConfigGui.getConfigElements(mod.getModId()), mod.getModId(), false, false, mod.getName() + " Configuration");
        this.entryList = new BCGuiConfigEntries(this, Minecraft.func_71410_x());
        this.initEntries.clear();
        this.initEntries.addAll(new ArrayList(this.entryList.listEntries));
    }

    public BCModConfigGui(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        super(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new BCGuiConfigEntries(this, this.field_146297_k);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u21b6") * 2;
        int resetGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u2604") * 2;
        int doneWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int checkWidth = this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"fml.configgui.applyGlobally", (Object[])new Object[0])) + 13;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5 + checkWidth) / 2;
        this.field_146292_n.add(new GuiButtonExt(2000, this.field_146294_l / 2 - buttonWidthHalf, this.field_146295_m - 29, doneWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.btnDefaultAll = new GuiUnicodeGlyphButton(2001, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.field_146295_m - 29, resetWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.field_146292_n.add(this.btnDefaultAll);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5, this.field_146295_m - 29, undoWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.field_146292_n.add(this.btnUndoAll);
        this.chkApplyGlobally = new GuiCheckBox(2003, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5 + resetWidth + 5, this.field_146295_m - 24, I18n.func_135052_a((String)"fml.configgui.applyGlobally", (Object[])new Object[0]), false);
        this.field_146292_n.add(this.chkApplyGlobally);
        this.undoHoverChecker = new HoverChecker((GuiButton)this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker((GuiButton)this.btnDefaultAll, 800);
        this.checkBoxHoverChecker = new HoverChecker((GuiButton)this.chkApplyGlobally, 800);
        ((BCGuiConfigEntries)this.entryList).initOverride();
    }

    private static List<IConfigElement> getConfigElements(String modid) {
        ArrayList<IConfigElement> configElements = new ArrayList<IConfigElement>();
        if (ModConfigParser.getModCategories(modid).size() <= 1) {
            LogHelperBC.dev("Single Cat Mode: " + ModConfigParser.getModCategories(modid));
            ModConfigParser.getModProperties(modid).forEach(property -> configElements.add((IConfigElement)new BCConfigElement((Property)property)));
        } else {
            LogHelperBC.dev("Detected Multi-Cat");
            ModConfigParser.getModCategories(modid).forEach(category -> configElements.add((IConfigElement)new BCConfigElement((ConfigCategory)category)));
        }
        return configElements;
    }

    public static class BCConfigElement
    extends ConfigElement {
        private Property theProp = null;
        private ConfigCategory category = null;
        private boolean categoriesFirst = true;

        public BCConfigElement(ConfigCategory category) {
            super(category);
            this.category = category;
        }

        public BCConfigElement(Property prop) {
            super(prop);
            this.theProp = prop;
        }

        public Property getProp() {
            return this.theProp;
        }

        public ConfigElement listCategoriesFirst(boolean categoriesFirst) {
            this.categoriesFirst = categoriesFirst;
            return super.listCategoriesFirst(categoriesFirst);
        }

        public List<IConfigElement> getChildElements() {
            if (!this.isProperty()) {
                BCConfigElement temp;
                ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
                Iterator ccI = this.category.getChildren().iterator();
                Iterator pI = this.category.getOrderedValues().iterator();
                boolean index = false;
                if (this.categoriesFirst) {
                    while (ccI.hasNext()) {
                        temp = new BCConfigElement((ConfigCategory)ccI.next());
                        if (!temp.showInGui()) continue;
                        elements.add((IConfigElement)temp);
                    }
                }
                while (pI.hasNext()) {
                    temp = new BCConfigElement((Property)pI.next());
                    if (!temp.showInGui()) continue;
                    elements.add((IConfigElement)temp);
                }
                if (!this.categoriesFirst) {
                    while (ccI.hasNext()) {
                        temp = new BCConfigElement((ConfigCategory)ccI.next());
                        if (!temp.showInGui()) continue;
                        elements.add((IConfigElement)temp);
                    }
                }
                return elements;
            }
            return null;
        }
    }
}

