/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class ReflectionUtils {
    private static final Map<FieldDescriptor, Field> FIELD_CACHE = new HashMap<FieldDescriptor, Field>();
    private static final Map<MethodDescriptor, Method> METHOD_CACHE = new HashMap<MethodDescriptor, Method>();

    public static <T> Field findField(@Nonnull Class<? extends T> classToAccess, @Nonnull String fieldName) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(classToAccess, fieldName);
        Field field = FIELD_CACHE.get(fieldDescriptor);
        if (field == null) {
            field = ObfuscationReflectionHelper.findField((Class)fieldDescriptor.clazz, (String)fieldDescriptor.fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            FIELD_CACHE.put(fieldDescriptor, field);
        }
        return field;
    }

    public static <T, E> T getFieldValue(@Nonnull Class<? extends E> classToAccess, @Nonnull E object, @Nonnull String fieldName) {
        return ReflectionUtils.getFieldValue(object, new FieldDescriptor(classToAccess, fieldName, false));
    }

    public static <T> T getStaticFieldValue(@Nonnull Class<?> classToAccess, @Nonnull String fieldName) {
        return ReflectionUtils.getFieldValue(null, new FieldDescriptor(classToAccess, fieldName, true));
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName) {
        try {
            ReflectionUtils.findField(classToAccess, fieldName).set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T getFieldValue(@Nullable Object obj, @Nonnull FieldDescriptor fieldDescriptor) {
        try {
            return (T)ReflectionUtils.findField(fieldDescriptor.clazz, fieldDescriptor.fieldName).get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, methodName, parameterTypes);
        Method method = METHOD_CACHE.get(methodDescriptor);
        if (method == null) {
            method = ObfuscationReflectionHelper.findMethod(clazz, (String)methodName, returnType, (Class[])parameterTypes);
            METHOD_CACHE.put(methodDescriptor, method);
        }
        return method;
    }

    private static class MethodDescriptor {
        @Nonnull
        private final Class<?> clazz;
        @Nonnull
        private final String methodName;
        @Nonnull
        private final Class<?>[] parameterTypes;

        public MethodDescriptor(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nonnull Class<?>[] parameterTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescriptor that = (MethodDescriptor)o;
            return this.clazz.equals(that.clazz) && this.methodName.equals(that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            int result = Objects.hash(this.clazz, this.methodName);
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }

    private static class FieldDescriptor {
        @Nonnull
        private final Class<?> clazz;
        @Nonnull
        private final String fieldName;
        private final boolean isStatic;

        public FieldDescriptor(@Nonnull Class<?> clazz, @Nonnull String fieldName, boolean isStatic) {
            this.clazz = clazz;
            this.fieldName = fieldName;
            this.isStatic = isStatic;
        }

        public FieldDescriptor(@Nonnull Class<?> clazz, @Nonnull String fieldName) {
            this(clazz, fieldName, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldDescriptor that = (FieldDescriptor)o;
            return this.isStatic == that.isStatic && this.clazz.equals(that.clazz) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.fieldName, this.isStatic);
        }
    }
}

