/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.helper;

import com.github.vfyjxf.jeiutilities.helper.IngredientHelper;
import com.github.vfyjxf.jeiutilities.helper.ReflectionUtils;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.Ingredients;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeHelper {
    public static <V, T> Pair<IRecipeWrapper, Integer> getRecipeWrapperAndIndex(@Nonnull Map<IIngredientType, List<String>> recipeUidMap, @Nonnull String recipeCategoryUid, @Nonnull T recipeOutput, @Nonnull IFocus<V> focus) {
        IRecipeCategory recipeCategory = JeiUtilitiesPlugin.recipeRegistry.getRecipeCategory(recipeCategoryUid);
        if (recipeCategory != null) {
            IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(focus.getValue());
            IFocus translatedFocus = ingredientHelper.translateFocus(focus, Focus::new);
            List recipes = JeiUtilitiesPlugin.recipeRegistry.getRecipeWrappers(recipeCategory, translatedFocus);
            IIngredientType outputType = JeiUtilitiesPlugin.ingredientRegistry.getIngredientType(recipeOutput);
            String outputUid = IngredientHelper.getUniqueId(recipeOutput);
            List outputMatchRecipes = recipes.parallelStream().filter(recipe -> {
                Ingredients outputIngredients = new Ingredients();
                recipe.getIngredients((IIngredients)outputIngredients);
                List outputSlots = outputIngredients.getOutputs(outputType);
                return outputSlots.parallelStream().flatMap(Collection::stream).map(t -> IngredientHelper.getUniqueId(IngredientHelper.getNormalize(t))).anyMatch(outputIngredientUid -> outputIngredientUid.equals(outputUid));
            }).collect(Collectors.toList());
            return outputMatchRecipes.parallelStream().filter(recipe -> RecipeHelper.isRecipeMatch(recipe, recipeUidMap)).findAny().map(recipe -> Pair.of((Object)recipe, (Object)recipes.indexOf(recipe))).orElse(null);
        }
        return null;
    }

    public static <V, T, R extends IRecipeWrapper> Pair<ICraftingRecipeWrapper, Integer> getCraftingRecipeWrapperAndIndex(@Nonnull ResourceLocation registerName, @Nonnull String recipeCategoryUid, @Nonnull T recipeOutput, @Nonnull IFocus<V> focus) {
        IRecipeCategory recipeCategory = JeiUtilitiesPlugin.recipeRegistry.getRecipeCategory(recipeCategoryUid);
        if (recipeCategory != null && recipeCategory.getUid().equals("minecraft.crafting")) {
            IIngredientHelper ingredientHelper = JeiUtilitiesPlugin.ingredientRegistry.getIngredientHelper(focus.getValue());
            IFocus translatedFocus = ingredientHelper.translateFocus(focus, Focus::new);
            List craftingRecipes = JeiUtilitiesPlugin.recipeRegistry.getRecipeWrappers(recipeCategory, translatedFocus).stream().filter(ICraftingRecipeWrapper.class::isInstance).map(ICraftingRecipeWrapper.class::cast).collect(Collectors.toList());
            List registerNameMatchRecipes = craftingRecipes.parallelStream().filter(recipe -> registerName.equals((Object)recipe.getRegistryName())).collect(Collectors.toList());
            return registerNameMatchRecipes.parallelStream().filter(recipe -> {
                Ingredients outputIngredients = new Ingredients();
                recipe.getIngredients((IIngredients)outputIngredients);
                List outputSlots = outputIngredients.getOutputs(JeiUtilitiesPlugin.ingredientRegistry.getIngredientType(recipeOutput));
                return outputSlots.parallelStream().flatMap(Collection::stream).map(t -> IngredientHelper.getUniqueId(IngredientHelper.getNormalize(t))).anyMatch(outputIngredientUid -> outputIngredientUid.equals(IngredientHelper.getUniqueId(recipeOutput)));
            }).findAny().map(recipe -> Pair.of((Object)recipe, (Object)craftingRecipes.indexOf(recipe))).orElse(null);
        }
        return null;
    }

    private static boolean isRecipeMatch(IRecipeWrapper recipeWrapper, Map<IIngredientType, List<String>> recipeUidMap) {
        Ingredients recipeIngredients = new Ingredients();
        recipeWrapper.getIngredients((IIngredients)recipeIngredients);
        Set ingredientTypes = ((Map)ReflectionUtils.getFieldValue(Ingredients.class, recipeIngredients, "inputs")).keySet();
        Set<IIngredientType> inputTypes = recipeUidMap.keySet();
        if (ingredientTypes.size() != inputTypes.size()) {
            return false;
        }
        if (!ingredientTypes.containsAll(inputTypes)) {
            return false;
        }
        for (IIngredientType ingredientType : ingredientTypes) {
            List<String> inputUid = recipeUidMap.get(ingredientType);
            List<String> ingredientUid = RecipeHelper.getIngredientsUid(recipeIngredients, ingredientType);
            if (inputUid.size() != ingredientUid.size()) {
                return false;
            }
            for (int i = 0; i < inputUid.size(); ++i) {
                if (inputUid.get(i).equals(ingredientUid.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static <V> List<String> getIngredientsUid(Ingredients ingredients, IIngredientType<V> ingredientType) {
        ArrayList<String> ingredientsUid = new ArrayList<String>();
        List ingredientList = ingredients.getInputs(ingredientType);
        for (List ingredientPerSlot : ingredientList) {
            Object first;
            Object object = first = ingredientPerSlot.isEmpty() ? null : ingredientPerSlot.stream().filter(Objects::nonNull).findFirst().orElse(null);
            if (first == null) {
                ingredientsUid.add("none");
                continue;
            }
            ingredientsUid.add(IngredientHelper.getUniqueId(first));
        }
        return ingredientsUid;
    }
}

