/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.support;

import info.tehnut.xtones.Tone;
import info.tehnut.xtones.Xtones;
import info.tehnut.xtones.config.XtonesConfig;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class ChiselSupport {
    public static final String CHISEL = "chisel";
    private static final String ADD_VARIATION = "add_variation";
    private static final String GROUP = "group";
    private static final String BLOCK = "block";
    private static final String META = "meta";

    private ChiselSupport() {
    }

    public static void init() {
        if (XtonesConfig.chiselMode != 2) {
            if (XtonesConfig.chiselMode == 0) {
                ChiselSupport.add(ChiselSupport.variation(Xtones.baseBlock(), "xtones"));
            }
            Xtones.blocks().forEach(block -> {
                if (XtonesConfig.chiselMode == 1) {
                    for (Tone tone : Tone.values()) {
                        ChiselSupport.add(ChiselSupport.variation(block, tone));
                    }
                } else {
                    ChiselSupport.add(ChiselSupport.variation(block, "xtones"));
                }
            });
        }
    }

    private static NBTTagCompound variation(Block block, String group) {
        String name = Objects.requireNonNull(block.getRegistryName()).toString();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(GROUP, group);
        tag.func_74778_a(BLOCK, name);
        return tag;
    }

    private static NBTTagCompound variation(Block block, Tone tone) {
        String group = Objects.requireNonNull(block.getRegistryName()).toString();
        NBTTagCompound tag = ChiselSupport.variation(block, group);
        tag.func_74768_a(META, tone.ordinal());
        return tag;
    }

    private static void add(NBTTagCompound variation) {
        FMLInterModComms.sendMessage((String)CHISEL, (String)ADD_VARIATION, (NBTTagCompound)variation);
    }
}

