/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.xtones.block;

import info.tehnut.xtones.Tone;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class XtoneBlock
extends Block {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private final boolean glassLike;
    private final BlockRenderLayer renderLayer;

    public XtoneBlock(Tone tone) {
        super(tone.isGlassLike() ? Material.field_151592_s : Material.field_151576_e);
        this.glassLike = tone.isGlassLike();
        if (this.glassLike) {
            this.renderLayer = BlockRenderLayer.TRANSLUCENT;
            this.func_149672_a(SoundType.field_185853_f);
            this.func_149713_g(0);
        } else {
            this.renderLayer = BlockRenderLayer.SOLID;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.glassLike) {
            IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
            if (state.func_177230_c() == neighbor.func_177230_c()) {
                return neighbor.func_177229_b(VARIANT) != state.func_177229_b(VARIANT);
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return !this.glassLike;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return !this.glassLike;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.VARIANTS[meta & 0xF]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static enum Variant implements IStringSerializable
    {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        ELEVEN,
        TWELVE,
        THIRTEEN,
        FOURTEEN,
        FIFTEEN,
        SIXTEEN;

        private static final Variant[] VARIANTS;

        public final String func_176610_l() {
            return this.toString();
        }

        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VARIANTS = Variant.values();
        }
    }
}

