/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.util.common.helpers;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tardis.mod.common.tileentity.TileEntityEgg;

public class FileHelper {
    public static Map<UUID, String> getPlayersFromServerFile() {
        File usernameCache = FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f("usernamecache.json");
        HashMap<UUID, String> usernames = new HashMap<UUID, String>();
        try {
            JsonObject object = new JsonParser().parse((Reader)new FileReader(usernameCache)).getAsJsonObject();
            Set entrySet = object.entrySet();
            for (Map.Entry elem : entrySet) {
                usernames.put(UUID.fromString((String)elem.getKey()), object.get((String)elem.getKey()).getAsString());
            }
        }
        catch (Exception e) {
            System.err.println(e.getStackTrace());
        }
        return usernames;
    }

    public static void readOrWriteARS(File dir) {
        try {
            dir = new File(dir.getPath() + File.separator + "tardis_ars.json");
            if (dir.exists()) {
                JsonReader reader = new GsonBuilder().create().newJsonReader((Reader)new FileReader(dir));
                reader.beginArray();
                while (reader.hasNext()) {
                    ItemStack stack = new ItemStack(Item.func_111206_d((String)reader.nextString()), 64);
                    TileEntityEgg.register(stack);
                }
                reader.endArray();
                reader.close();
            } else {
                dir.createNewFile();
                JsonWriter writer = new GsonBuilder().setPrettyPrinting().create().newJsonWriter((Writer)new FileWriter(dir));
                writer.beginArray();
                writer.value("tardis:toyota_hexagon_1");
                writer.endArray();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

