/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.tardis.mod.util.common.helpers.Helper;

public class GenerateJson {
    public static void generateFacingBlockstate(String name) {
        try {
            File f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "\\..\\src\\main\\resources\\assets\\tardis\\blockstates\\" + name + ".json");
            if (!f.exists()) {
                f.createNewFile();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonWriter jw = gson.newJsonWriter((Writer)fw);
            String model = "tardis:" + name;
            jw.beginObject();
            jw.name("forge_marker").value(1L);
            jw.name("defaults");
            jw.beginObject();
            jw.name("model").value(model);
            jw.endObject();
            jw.name("variants");
            jw.beginObject();
            for (EnumFacing face : EnumFacing.field_176754_o) {
                jw.name("facing=" + face.func_176742_j());
                jw.beginObject();
                jw.name("model").value(model);
                jw.name("y").value((double)Helper.getAngleFromFacing(face));
                jw.endObject();
            }
            jw.name("inventory");
            GenerateJson.writeJSONVarient(jw, model);
            jw.name("normal");
            GenerateJson.writeJSONVarient(jw, model);
            jw.endObject();
            jw.endObject();
            ((Writer)fw).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void genCubeAll(String name) {
        try {
            File f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "\\..\\src\\main\\resources\\assets\\tardis\\blockstates\\" + name + ".json");
            if (!f.exists()) {
                f.createNewFile();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonWriter jw = gson.newJsonWriter((Writer)writer);
            jw.beginObject();
            jw.name("forge_marker").value(1L);
            jw.name("defaults");
            jw.beginObject();
            jw.name("model").value("cube_all");
            jw.name("textures");
            jw.beginObject();
            jw.name("all").value("tardis:blocks/hellbent/" + name);
            jw.endObject();
            jw.endObject();
            jw.name("variants");
            jw.beginObject();
            jw.name("inventory");
            jw.beginArray();
            jw.beginObject();
            jw.endObject();
            jw.endArray();
            jw.name("normal");
            jw.beginArray();
            jw.beginObject();
            jw.endObject();
            jw.endArray();
            jw.endObject();
            jw.endObject();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void genHalfSlab(String name) {
        try {
            File f = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + "\\..\\src\\main\\resources\\assets\\tardis\\blockstates\\" + name + ".json");
            if (!f.exists()) {
                f.createNewFile();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonWriter jw = gson.newJsonWriter((Writer)writer);
            jw.beginObject();
            jw.name("forge_marker").value(1L);
            jw.name("defaults");
            jw.beginObject();
            jw.name("model").value("half_slab");
            jw.name("textures");
            jw.beginObject();
            jw.name("bottom").value("tardis:blocks/" + name);
            jw.name("top").value("tardis:blocks/" + name);
            jw.name("side").value("tardis:blocks/" + name);
            jw.endObject();
            jw.endObject();
            jw.name("variants");
            jw.beginObject();
            jw.name("top=true");
            jw.beginArray();
            jw.beginObject();
            jw.endObject();
            jw.endArray();
            jw.name("top=false");
            jw.beginArray();
            jw.beginObject();
            jw.name("x").value(180L);
            jw.endObject();
            jw.endArray();
            jw.endObject();
            jw.endObject();
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeJSONVarient(JsonWriter jw, String model) throws IOException {
        jw.beginObject();
        jw.name("model").value(model);
        jw.endObject();
    }
}

