/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tardis", name="TARDIS Mod")
public class TardisConfig {
    @Config.RequiresMcRestart
    @Config.LangKey(value="config.category.dims")
    public static final Dimensions Dimensions = new Dimensions();
    @Config.LangKey(value="config.entity")
    public static final UseEntities USE_ENTITIES = new UseEntities();
    @Config.LangKey(value="config.misc")
    public static final Misc MISC = new Misc();
    @Config.LangKey(value="config.boti")
    public static final Boti BOTI = new Boti();

    @Mod.EventBusSubscriber(modid="tardis")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("tardis")) {
                ConfigManager.sync((String)"tardis", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Boti {
        @Config.LangKey(value="config.boti.enabled")
        @Config.Comment(value={"This is used to toggle the bigger on the inside effect"})
        public boolean enabled = true;
        @Config.LangKey(value="config.boti.skip")
        @Config.Comment(value={"This is used to block any blocks from being rendered in the Bigger on the inside effect (For compatibility) ex. ic2:te or if you want to block all of ic2 ic2:*"})
        public String[] modids = new String[0];
        @Config.LangKey(value="config.boti.ticks")
        @Config.Comment(value={"How many ticks before we poll the world again"})
        public int botiTickRate = 100;
        @Config.LangKey(value="config.boti.fast")
        @Config.Comment(value={"If this is enabled boti will check sides before rendering. Set this to false if you crash"})
        public boolean checkSides = true;
    }

    public static class Misc {
        @Config.LangKey(value="config.misc.invasion")
        public boolean invasions = true;
        @Config.LangKey(value="config.misc.givekey")
        @Config.Comment(value={"If enabled, this will give the player a Tardis coral on their first join"})
        public boolean givePlayerKey = false;
        @Config.LangKey(value="config.misc.maxrand")
        @Config.Comment(value={"Set to Zero to make it anywhere in the world."})
        public int maxRandom = 5000;
        @Config.LangKey(value="config.misc.on.kill")
        public boolean killControlsOnKillCommand = false;
        @Config.LangKey(value="config.misc.shake")
        public boolean camShake = true;
        @Config.LangKey(value="config.misc.recharge")
        public float artronRechargeRate = 4.0f;
    }

    public static class UseEntities {
        @Config.LangKey(value="config.entity.allowed")
        public boolean entities = true;
        @Config.LangKey(value="config.entity.cybermen.spawnchance")
        public int cybermanSpawnChance = 50;
        @Config.LangKey(value="config.entity.adipose.spawnchance")
        public int adiposeSpawnChance = 10;
    }

    public static class Dimensions {
        @Config.LangKey(value="config.dims")
        public int[] bDims = new int[0];
        @Config.LangKey(value="config.dim.usewhitelist")
        @Config.Comment(value={"If this is enabled, only a specific list of dimensions can be travelled to via the Tardis"})
        public boolean USE_WHITELIST = false;
        @Config.LangKey(value="config.setdim")
        @Config.Comment(value={"If this is enabled, You can set dimensions manually below"})
        public boolean setDimension = false;
        @Config.LangKey(value="config.tDim")
        @Config.Comment(value={"Tardis Dimension ID"})
        public int tardisDimension = 10;
        @Config.LangKey(value="config.bhDim")
        @Config.Comment(value={"Space Dimension ID"})
        public int spaceDimension = 22;
        @Config.LangKey(value="config.telosDim")
        @Config.Comment(value={"Telos Dimension ID"})
        public int telosDimension = 23;
        @Config.LangKey(value="config.moonDim")
        @Config.Comment(value={"Moon Dimension ID"})
        public int moonDimension = 24;
        @Config.LangKey(value="config.gallifreyDim")
        @Config.Comment(value={"Gallifrey Dimension ID"})
        public int gallifreyDimension = 24;
        @Config.LangKey(value="config.tardis.oregen")
        @Config.Comment(value={"Should the TARDIS Mod generate ores?"})
        public boolean generateOres = true;
    }
}

