/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.tileentity;

import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tardis.mod.common.ars.ConsoleRoom;
import net.tardis.mod.common.blocks.BlockTardisCoral;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.ItemKey;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.RiftHelper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class TileEntityTardisCoral
extends TileEntity
implements ITickable {
    public int time = 0;
    public int maxTime = -1;
    public UUID owner;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.time = compound.func_74762_e("time");
        if (compound.func_74764_b("owner_id")) {
            this.owner = UUID.fromString(compound.func_74779_i("owner_id"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("time", this.time);
        if (this.owner != null) {
            compound.func_74778_a("owner_id", this.owner.toString());
        }
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.owner != null) {
            int newGrowStage;
            this.maxTime = RiftHelper.isRift(this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l(), this.field_145850_b) ? 24000 : 48000;
            ++this.time;
            int growthStage = (Integer)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTardisCoral.GROW_STAGE);
            if (growthStage != (newGrowStage = Math.round(this.time / (this.maxTime / 3)))) {
                if (newGrowStage > 3) {
                    this.grow();
                } else {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockTardisCoral.GROW_STAGE, (Comparable)Integer.valueOf(newGrowStage)), 3);
                }
            }
        }
    }

    public void grow() {
        TileEntity te;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos pos = TardisHelper.getTardis(this.owner);
        WorldServer tardisWorld = this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
        if (!(tardisWorld == null || pos == null || (te = tardisWorld.func_175625_s(pos)) != null && te instanceof TileEntityTardis)) {
            ConsoleRoom.CONSOLE_ROOMS.get(0).generate(this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID), pos);
            tardisWorld.func_175656_a(pos, TBlocks.console_02.func_176223_P());
            TileEntityTardis tardis = (TileEntityTardis)tardisWorld.func_175625_s(pos);
            this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
            tardis.setAbsoluteDesination(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension());
            tardis.startFlight();
            tardis.travel();
            ItemStack keyStack = new ItemStack(TItems.key);
            ItemKey.setPos(keyStack, pos);
            EntityPlayerMP entityPlayer = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
            if (entityPlayer != null) {
                InventoryHelper.func_180173_a((World)entityPlayer.field_70170_p, (double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v, (ItemStack)keyStack);
            } else {
                try {
                    File f = new File(this.field_145850_b.func_73046_m().func_71238_n() + "/pending_keys.json");
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    if (f.exists()) {
                        JsonReader jr = new JsonReader((Reader)new FileReader(f));
                        jr.beginObject();
                        while (jr.hasNext()) {
                            map.put(jr.nextName(), Long.parseLong(jr.nextString()));
                        }
                        jr.endArray();
                        jr.close();
                    } else {
                        f.createNewFile();
                    }
                    map.put(this.owner.toString(), pos.func_177986_g());
                    GsonBuilder gb = new GsonBuilder();
                    gb.setPrettyPrinting();
                    JsonWriter jw = gb.create().newJsonWriter((Writer)new FileWriter(f));
                    jw.beginObject();
                    for (String name : map.keySet()) {
                        jw.name(name).value(((Long)map.get(name)).toString());
                    }
                    jw.endObject();
                    jw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.func_145831_w().func_175698_g(this.func_174877_v());
    }

    public void setOwner(UUID id) {
        this.owner = id;
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

