/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.Tardis;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.client.worldshell.MessageSyncWorldShell;
import net.tardis.mod.client.worldshell.WorldBoti;
import net.tardis.mod.client.worldshell.WorldShell;
import net.tardis.mod.common.IDoor;
import net.tardis.mod.common.blocks.BlockTardisTop;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityTardis;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.enums.EnumTardisState;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.DummyTardis;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.misc.TimedDecal;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageDemat;
import net.tardis.mod.network.packets.MessageDoorOpen;
import net.tardis.mod.network.packets.MessageRequestBOTI;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class TileEntityDoor
extends TileEntity
implements ITickable,
IInventory,
IContainsWorldShell {
    public static int radius = 20;
    public static AxisAlignedBB aabb = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 2.0, 0.75);
    private static AxisAlignedBB RENDER_BB = new AxisAlignedBB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0);
    public BlockPos consolePos = BlockPos.field_177992_a;
    public SoundEvent knockSound = SoundEvents.field_187927_ha;
    public boolean isLocked = true;
    public int lockCooldown = 0;
    private boolean forceField = false;
    public int openingTicks = 0;
    public float alpha = 0.0f;
    public boolean isDemat;
    public boolean isRemat = true;
    private WorldShell worldShell = new WorldShell(BlockPos.field_177992_a);
    private int lightLevel = 0;
    private float renderAngle = 90.0f;
    private boolean requiresUpdate = true;
    public World clientWorld;
    private boolean isStealth = true;
    private ForgeChunkManager.Ticket loadingTicket;
    public static final AxisAlignedBB NORTH = new AxisAlignedBB(0.0, 0.0, -0.1, 1.0, 2.0, 0.0);
    public static final AxisAlignedBB EAST = new AxisAlignedBB(1.0, 0.0, 0.0, 1.1, 2.0, 1.0);
    public static final AxisAlignedBB WEST = new AxisAlignedBB(-0.1, 0.0, 0.0, 0.0, 2.0, 1.0);
    public static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 2.0, 1.1);
    public ArrayList<TimedDecal> forcefieldHits = new ArrayList();
    private ArrayList<Integer> hitEntitiesIDs = new ArrayList();

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.consolePos = BlockPos.func_177969_a((long)tag.func_74763_f("tPos"));
        this.isLocked = tag.func_74767_n("locked");
        this.isDemat = tag.func_74767_n("demat");
        this.isRemat = tag.func_74767_n("remat");
        this.alpha = tag.func_74760_g("alpha");
        this.forceField = tag.func_74767_n("forcefield");
        this.renderAngle = tag.func_74760_g("renderAngle");
        this.isStealth = tag.func_74767_n("stealth");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74772_a("tPos", this.consolePos.func_177986_g());
        tag.func_74757_a("locked", this.isLocked);
        tag.func_74757_a("demat", this.isDemat);
        tag.func_74757_a("remat", this.isRemat);
        tag.func_74776_a("alpha", this.alpha);
        tag.func_74757_a("forcefield", this.forceField);
        tag.func_74776_a("renderAngle", this.renderAngle);
        tag.func_74757_a("stealth", this.isStealth);
        return super.func_189515_b(tag);
    }

    public void toggleLocked(EntityPlayer player) {
        TileEntityTardis tardis;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (tardis = (TileEntityTardis)this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(this.getConsolePos())) != null && tardis.getTardisState() == EnumTardisState.NORMAL && TardisHelper.hasValidKey((EntityLivingBase)player, this.consolePos) && this.lockCooldown == 0 && this.alpha >= 1.0f) {
            this.lockCooldown = 20;
            this.isLocked = !this.isLocked;
            this.func_70296_d();
            NetworkHandler.NETWORK.sendToDimension((IMessage)new MessageDoorOpen(this.func_174877_v(), this), this.field_145850_b.field_73011_w.getDimension());
            if (this.isLocked) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.door_closed, SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.door_open, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tardis.locked." + this.isLocked, new Object[0]), true);
            ControlDoor door = tardis.getDoor();
            if (door != null) {
                door.setOpen(!this.isLocked());
                for (Entity e : tardis.func_145831_w().func_72872_a(Entity.class, Block.field_185505_j.func_191194_a(door.func_174791_d()).func_186662_g(20.0))) {
                    if (!(e instanceof IDoor)) continue;
                    ((IDoor)e).setOpen(!this.isLocked());
                }
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
        }
    }

    public void toggleLockedNoKey(EntityPlayer player) {
        if (this.lockCooldown == 0) {
            this.lockCooldown = 20;
            this.isLocked = !this.isLocked;
            this.func_70296_d();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tardis.locked." + this.isLocked, new Object[0]), true);
        }
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockTardisTop) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockTardisTop.FACING);
        }
        return EnumFacing.NORTH;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        this.handleEnter();
        if (!this.field_145850_b.field_72995_K) {
            Object ws;
            TileEntityTardis tardis;
            if (this.loadingTicket != null) {
                this.loadingTicket = ForgeChunkManager.requestTicket((Object)Tardis.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loadingTicket, (ChunkPos)this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l());
            }
            if ((tardis = (TileEntityTardis)(ws = (WorldServer)this.field_145850_b).func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(this.getConsolePos())) == null) {
                return;
            }
            if (this.field_145850_b.func_82737_E() % (long)TardisConfig.BOTI.botiTickRate == 0L) {
                this.updateWorldShell();
            }
            if (this.lockCooldown > 0) {
                --this.lockCooldown;
            }
        }
        if (this.openingTicks > 0) {
            --this.openingTicks;
        }
        if (this.isRemat) {
            if (this.alpha < 1.0f) {
                this.alpha += 0.005f;
                if (!this.field_145850_b.field_72995_K) {
                    for (Entity e : this.field_145850_b.func_72872_a(Entity.class, aabb.func_186670_a(this.func_174877_v().func_177977_b()))) {
                        try {
                            ((TileEntityTardis)this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(this.getConsolePos())).enterTARDIS(e);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                this.isRemat = false;
                this.alpha = 1.0f;
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
            }
        }
        if (this.isDemat) {
            this.alpha -= 0.005f;
            if (this.alpha <= 0.0f) {
                this.isDemat = false;
                this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                this.field_145850_b.func_175656_a(this.func_174877_v().func_177977_b(), Blocks.field_150350_a.func_176223_P());
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loadingTicket, (ChunkPos)this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l());
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loadingTicket);
                this.loadingTicket = null;
            }
        }
        if (!this.isRemat && !this.isDemat) {
            this.alpha = 1.0f;
        }
        if (this.field_145850_b.field_72995_K && !this.isLocked() && (this.worldShell.getOffset().equals((Object)BlockPos.field_177992_a) || this.requiresUpdate)) {
            NetworkHandler.NETWORK.sendToServer((IMessage)new MessageRequestBOTI(this.func_174877_v()));
            this.setupClientWorld();
            this.requiresUpdate = false;
        }
        if (this.isLocked() && !this.worldShell.getOffset().equals((Object)BlockPos.field_177992_a)) {
            this.worldShell = new WorldShell(BlockPos.field_177992_a);
        }
        if (this.forceField) {
            this.handleForceField();
        }
        ArrayList<TimedDecal> deadHits = new ArrayList<TimedDecal>();
        for (TimedDecal dec : this.forcefieldHits) {
            int left = dec.shrinkTime();
            if (left > 0) continue;
            deadHits.add(dec);
        }
        for (TimedDecal dec : deadHits) {
            this.forcefieldHits.remove(dec);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupClientWorld() {
        this.clientWorld = new WorldBoti(this.field_145850_b.field_73011_w.getDimension(), (WorldClient)this.field_145850_b, this.worldShell);
    }

    public void handleEnter() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.isLocked()) {
                return;
            }
            TileEntityTardis tardis = (TileEntityTardis)this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(this.getConsolePos());
            if (tardis == null) {
                return;
            }
            EnumFacing face = this.getFacing();
            AxisAlignedBB bb = face == EnumFacing.NORTH ? NORTH : (face == EnumFacing.EAST ? EAST : (face == EnumFacing.SOUTH ? SOUTH : WEST));
            bb = bb.func_186670_a(this.func_174877_v().func_177977_b());
            for (Entity e : this.field_145850_b.func_72872_a(Entity.class, bb)) {
                tardis.enterTARDIS(e);
            }
        }
    }

    public boolean canOpen() {
        return !this.isDemat && !this.isRemat;
    }

    public void sendDematPacket(boolean demat) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkHandler.NETWORK.sendToAllAround((IMessage)new MessageDemat(this.func_174877_v(), demat), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 64.0));
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean b) {
        this.isLocked = b;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
        }
    }

    public List<BlockPos> getBlocksInAABB(AxisAlignedBB bb) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        if (bb == null) {
            return poses;
        }
        int x = (int)bb.field_72340_a;
        while ((double)x < bb.field_72336_d) {
            int y = (int)bb.field_72338_b;
            while ((double)y < bb.field_72337_e) {
                int z = (int)bb.field_72339_c;
                while ((double)z < bb.field_72334_f) {
                    poses.add(new BlockPos(x, y, z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return poses;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_BB.func_186670_a(this.func_174877_v());
    }

    public void handleForceField() {
        TileEntity te;
        WorldServer ws;
        this.field_145850_b.func_72872_a(Entity.class, RENDER_BB.func_186670_a(this.func_174877_v())).forEach(entity -> {
            if (entity instanceof IProjectile || entity instanceof EntityThrowable) {
                entity.func_70106_y();
                if (!this.hitEntitiesIDs.contains(entity.func_145782_y())) {
                    this.hitEntitiesIDs.add(entity.func_145782_y());
                    this.forcefieldHits.add(new TimedDecal(entity.func_174791_d(), 20));
                }
            }
            if (entity instanceof IMob) {
                Vec3d dir = entity.func_174791_d().func_178788_d(new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5)).func_72432_b().func_186678_a(0.25);
                entity.field_70159_w = dir.field_72450_a;
                entity.field_70181_x = dir.field_72448_b;
                entity.field_70179_y = dir.field_72449_c;
                this.hitEntitiesIDs.add(entity.func_145782_y());
                this.forcefieldHits.add(new TimedDecal(entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e() / 2.0, 0.0), 20));
            }
        });
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 60L == 0L && (ws = this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)) != null && (te = ws.func_175625_s(this.getConsolePos())) instanceof TileEntityTardis) {
            TileEntityTardis tardis = (TileEntityTardis)te;
            tardis.setArtron(tardis.getArtron() - 1.0f);
            if (tardis.getArtron() <= 0.0f) {
                this.setForcefield(false);
            }
        }
    }

    public BlockPos getConsolePos() {
        return this.consolePos;
    }

    public void setConsolePos(BlockPos pos) {
        this.consolePos = pos.func_185334_h();
        this.func_70296_d();
    }

    public void knock() {
        WorldServer ws;
        if (!this.field_145850_b.field_72995_K && this.getConsolePos() != null && (ws = this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)) != null) {
            TileEntity te = ws.func_175625_s(this.getConsolePos());
            if (te instanceof TileEntityTardis) {
                ControlDoor door = ((TileEntityTardis)te).getDoor();
                if (door != null) {
                    ws.func_184133_a(null, door.func_180425_c(), this.knockSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                ws.func_184133_a(null, this.getConsolePos(), this.knockSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public IInventory getLinkedInv() {
        TileEntity te;
        WorldServer ws;
        if (!this.field_145850_b.field_72995_K && this.getConsolePos() != null && (ws = DimensionManager.getWorld((int)TDimensions.TARDIS_ID)) != null && (te = ws.func_175625_s(this.getConsolePos())) instanceof TileEntityTardis) {
            return (TileEntityTardis)te;
        }
        return DummyTardis.INSTANCE;
    }

    public String func_70005_c_() {
        return this.getLinkedInv().func_70005_c_();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.getLinkedInv().func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.getLinkedInv().func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.getLinkedInv().func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.getLinkedInv().func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.getLinkedInv().func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getLinkedInv().func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.getLinkedInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.getLinkedInv().func_174888_l();
    }

    @Override
    public WorldShell getWorldShell() {
        return this.worldShell;
    }

    @Override
    public void setWorldShell(WorldShell worldShell) {
        this.worldShell = worldShell;
    }

    public void setRemat() {
        this.alpha = 0.0f;
        this.isRemat = true;
        this.sendDematPacket(false);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 2);
        }
    }

    public void setDemat() {
        this.alpha = 1.0f;
        this.isDemat = true;
        this.setLocked(true);
        this.sendDematPacket(true);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 2);
        }
    }

    public void forceVisible() {
        this.alpha = 1.0f;
        this.isDemat = false;
        this.isRemat = false;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public void setLightLevel(int light) {
        this.lightLevel = light;
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
    }

    @Override
    public int getDimension() {
        return TDimensions.TARDIS_ID;
    }

    public float getDoorAngle() {
        return this.renderAngle;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("angle", this.renderAngle);
        tag.func_74757_a("demat", this.isDemat);
        tag.func_74757_a("remat", this.isRemat);
        tag.func_74757_a("locked", this.isLocked);
        tag.func_74768_a("light", this.lightLevel);
        tag.func_74757_a("stealth", this.isStealth);
        tag.func_74757_a("forcefield", this.forceField);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.renderAngle = pkt.func_148857_g().func_74760_g("angle");
        this.isDemat = pkt.func_148857_g().func_74767_n("demat");
        this.isRemat = pkt.func_148857_g().func_74767_n("remat");
        this.isLocked = pkt.func_148857_g().func_74767_n("locked");
        this.lightLevel = pkt.func_148857_g().func_74762_e("light");
        this.isStealth = pkt.func_148857_g().func_74767_n("stealth");
        this.forceField = pkt.func_148857_g().func_74767_n("forcefield");
        this.requiresUpdate = true;
    }

    public void updateWorldShell() {
        WorldServer ws;
        TileEntityTardis tardis;
        if (this.worldShell == null || !this.worldShell.getOffset().equals((Object)this.getConsolePos())) {
            this.worldShell = new WorldShell(this.getOffset());
        }
        if ((tardis = (TileEntityTardis)(ws = this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)).func_175625_s(this.getConsolePos())) == null) {
            return;
        }
        ControlDoor door = tardis.getDoor();
        AxisAlignedBB BOTI = Block.field_185505_j.func_186662_g(20.0);
        if (door != null) {
            BOTI = BOTI.func_186670_a(door.func_180425_c().func_177967_a(door.func_174811_aO(), MathHelper.func_76128_c((double)BOTI.field_72336_d) - 1));
            door.func_184212_Q().func_187227_b(ControlDoor.FACING, (Object)Float.valueOf(Helper.getAngleFromFacing(this.getFacing())));
        } else {
            BOTI = BOTI.func_186670_a(this.getConsolePos());
        }
        for (BlockPos blockPos : this.getBlocksInAABB(BOTI)) {
            if (ws.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) continue;
            this.worldShell.blockMap.put(blockPos, new BlockStorage(ws.func_180495_p(blockPos).func_185899_b((IBlockAccess)ws, blockPos), ws.func_175625_s(blockPos), Helper.getLight((World)ws, blockPos) == 0 ? 4 : Helper.getLight((World)ws, blockPos)));
        }
        ArrayList<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
        for (Entity e : ws.func_72872_a(Entity.class, BOTI)) {
            ResourceLocation key = EntityList.func_191301_a((Entity)e);
            if (key == null || e instanceof ControlDoor) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", key.toString());
            entities.add(e.func_189511_e(tag));
        }
        this.worldShell.setEntities(entities);
        this.renderAngle = tardis.getDoor() == null ? 90.0f : tardis.getDoor().field_70177_z;
        this.requiresUpdate = true;
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), iBlockState, iBlockState, 2);
        this.requiresUpdate = false;
    }

    public BlockPos getOffset() {
        ControlDoor door;
        TileEntityTardis tardis;
        if (!this.field_145850_b.field_72995_K && (tardis = (TileEntityTardis)this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(this.getConsolePos())) != null && (door = tardis.getDoor()) != null) {
            return door.func_180425_c();
        }
        return this.getConsolePos().func_177967_a(this.getFacing().func_176734_d(), 11);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public World getRenderWorld() {
        return this.clientWorld;
    }

    public boolean isStealth() {
        return this.isStealth;
    }

    public void setStealth(boolean isStealth) {
        this.isStealth = isStealth;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.updateWorldShell();
            NetworkHandler.NETWORK.sendToAllAround((IMessage)new MessageSyncWorldShell(this.worldShell, this.func_174877_v(), MessageSyncWorldShell.EnumType.BLOCKS), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 32.0));
        }
    }

    public EntityTardis createTardisEntity() {
        EntityTardis tardis = new EntityTardis(this.field_145850_b);
        tardis.setConsole(this.getConsolePos());
        return tardis;
    }

    public void setForcefield(boolean force) {
        this.forceField = force;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            WorldServer ws = this.field_145850_b.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
            TileEntity te = this.field_145850_b.func_175625_s(this.getConsolePos());
            if (te instanceof TileEntityTardis) {
                ((TileEntityTardis)te).setForceFieldEnabled(force);
            }
        }
    }

    public boolean getForcefield() {
        return this.forceField;
    }

    public void addForcefieldHitDecal(TimedDecal decal) {
        this.forcefieldHits.add(decal);
    }

    public class NBT {
        public static final String LOCKED = "locked";
    }
}

