/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.systems;

import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;

public class SystemThermo
extends TardisSystems.BaseSystem {
    boolean crashed = false;
    boolean hasRun = false;
    boolean repaired = false;

    @Override
    public void onUpdate(World world, BlockPos consolePos) {
        TileEntityTardis tardis;
        if (this.crashed && !this.hasRun) {
            tardis = (TileEntityTardis)world.func_175625_s(consolePos);
            this.hasRun = true;
            if (tardis != null) {
                tardis.setAbsoluteDesination(consolePos.func_177964_d(5), TDimensions.TARDIS_ID);
                tardis.startFlight();
                tardis.travel();
                return;
            }
        }
        if (this.crashed && this.getHealth() > 0.0f) {
            this.crashed = false;
            this.hasRun = false;
            tardis = (TileEntityTardis)world.func_175625_s(consolePos);
            tardis.setDesination(tardis.returnLocation.getPos(), tardis.returnLocation.getDimension());
            tardis.startFlight();
            this.repaired = false;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.crashed = tag.func_74767_n("crash");
        this.repaired = tag.func_74767_n("repaired");
    }

    @Override
    public NBTTagCompound writetoNBT(NBTTagCompound tag) {
        tag.func_74757_a("crash", this.crashed);
        tag.func_74757_a("repaired", this.repaired);
        return super.writetoNBT(tag);
    }

    @Override
    public void damage() {
        this.setHealth(this.getHealth() - 0.2f);
        if (this.getHealth() <= 0.0f) {
            this.crashed = true;
        }
    }

    @Override
    public Item getRepairItem() {
        return TItems.thermo;
    }

    @Override
    public String getNameKey() {
        return "system.tardis.thermo";
    }

    @Override
    public String getUsage() {
        return "Without this system, your TARDIS will not land correctly, resulting in your TARDIS landing inside the control room";
    }

    @Override
    public void wear() {
        this.setHealth(this.getHealth() - 0.001f);
    }
}

