/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.tardis.mod.common.screwdriver.IScrew;
import net.tardis.mod.common.screwdriver.ScrewdriverHandler;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.PlayerHelper;

public class ItemSonic
extends Item {
    public static List<Item> SONICS = new ArrayList<Item>();
    private SoundEvent sonicSound;

    public ItemSonic(SoundEvent sonicSound) {
        this(sonicSound, false);
    }

    public ItemSonic(SoundEvent sonicSound, boolean hasSpecial) {
        this.func_77625_d(1);
        this.sonicSound = sonicSound;
        SONICS.add(this);
        if (hasSpecial) {
            this.func_185043_a(new ResourceLocation("special"), (stack, worldIn, entityIn) -> {
                NBTTagCompound tag = Helper.getStackTag(stack);
                if (tag == null || !tag.func_74764_b("special")) {
                    return 0.0f;
                }
                return Helper.getStackTag(stack).func_74760_g("special");
            });
        }
    }

    public static int getOpen(ItemStack stack) {
        return Helper.getStackTag(stack).func_74762_e("open");
    }

    public static void setOpen(ItemStack stack, int amount) {
        Helper.getStackTag(stack).func_74768_a("open", amount);
    }

    public static int getCharge(ItemStack stack) {
        return 100;
    }

    public static void setCharge(ItemStack stack, int charge) {
        Helper.getStackTag(stack).func_74768_a("charge", MathHelper.func_76125_a((int)charge, (int)0, (int)100));
    }

    private static void setMode(ItemStack stack, int i) {
        NBTTagCompound tag = Helper.getStackTag(stack);
        if (tag.func_74764_b("mode")) {
            int newModeId = ItemSonic.getMode(stack) + 1;
            if (newModeId >= ScrewdriverHandler.MODES.size()) {
                newModeId = 0;
            }
            tag.func_74768_a("mode", newModeId);
        } else {
            tag.func_74768_a("mode", 0);
        }
    }

    public static int getMode(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("mode")) {
            return stack.func_77978_p().func_74762_e("mode");
        }
        ItemSonic.setMode(stack, 0);
        return ItemSonic.getMode(stack);
    }

    public static BlockPos getConsolePos(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("console_pos")) {
            return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("console_pos"));
        }
        return BlockPos.field_177992_a;
    }

    public static void setConsolePos(ItemStack stack, BlockPos pos) {
        NBTTagCompound tag = Helper.getStackTag(stack);
        tag.func_74772_a("console_pos", pos.func_177986_g());
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemSonic.setCharge(stack, 100);
        ItemSonic.setOpen(stack, 0);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack held = player.func_184586_b(handIn);
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return super.func_77659_a(worldIn, player, handIn);
        }
        IScrew sc = ScrewdriverHandler.MODES.get(ItemSonic.getMode(held));
        RayTraceResult lookPos = this.func_77621_a(worldIn, player, true);
        ItemSonic.setOpen(held, 1);
        if (lookPos != null && lookPos.func_178782_a() != null && player.func_70093_af() && worldIn.func_180495_p(lookPos.func_178782_a()).func_177230_c() != Blocks.field_150367_z) {
            ItemSonic.setMode(held, ItemSonic.getMode(held) + 1);
            if (!worldIn.field_72995_K) {
                PlayerHelper.sendMessage(player, new TextComponentTranslation(ScrewdriverHandler.MODES.get(ItemSonic.getMode(held)).getName(), new Object[0]).func_150254_d(), true);
            }
        }
        if (ItemSonic.getCharge(held) >= sc.energyRequired()) {
            EnumActionResult result = sc.performAction(worldIn, player, handIn);
            if (sc.causesCoolDown() && result.equals((Object)EnumActionResult.SUCCESS) && !player.func_70093_af()) {
                this.cooldown(held.func_77973_b(), player, sc.getCoolDownAmount());
                worldIn.func_184133_a(null, player.func_180425_c(), this.sonicSound, SoundCategory.PLAYERS, 0.25f, 1.0f);
                ItemSonic.setCharge(held, ItemSonic.getCharge(held) - sc.energyRequired());
            }
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return EnumActionResult.FAIL;
        }
        ItemStack held = player.func_184586_b(hand);
        EnumActionResult result = EnumActionResult.FAIL;
        ItemSonic.setOpen(held, 1);
        Helper.getStackTag(held).func_74768_a("charge", ItemSonic.getCharge(held));
        if (ItemSonic.getMode(held) >= 0) {
            IScrew sc = ScrewdriverHandler.MODES.get(ItemSonic.getMode(held));
            if (ItemSonic.getCharge(held) >= sc.energyRequired()) {
                result = sc.blockInteraction(worldIn, pos, worldIn.func_180495_p(pos), player);
                if (sc.causesCoolDown() && EnumActionResult.SUCCESS.equals((Object)result) && !player.func_70093_af()) {
                    this.cooldown(held.func_77973_b(), player, sc.getCoolDownAmount());
                    worldIn.func_184133_a(null, player.func_180425_c(), this.sonicSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    ItemSonic.setCharge(held, ItemSonic.getCharge(held) - sc.energyRequired());
                }
            }
        }
        return result;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        ItemStack held = player.func_184586_b(hand);
        boolean flag = false;
        ItemSonic.setOpen(stack, 1);
        if (ItemSonic.getMode(held) >= 0) {
            IScrew sc = ScrewdriverHandler.MODES.get(ItemSonic.getMode(held));
            if (ItemSonic.getCharge(held) >= sc.energyRequired()) {
                flag = sc.entityInteraction(stack, player, target, hand);
                if (sc.causesCoolDown() && flag && !player.func_70093_af()) {
                    this.cooldown(stack.func_77973_b(), player, sc.getCoolDownAmount());
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), this.sonicSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    ItemSonic.setCharge(held, ItemSonic.getCharge(held) - sc.energyRequired());
                }
            }
        }
        return flag;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IScrew currentMode = ScrewdriverHandler.MODES.get(ItemSonic.getMode(stack));
        tooltip.add("Charge: " + ItemSonic.getCharge(stack));
        tooltip.add("Mode: " + new TextComponentTranslation(currentMode.getName(), new Object[0]).func_150254_d());
        if (GuiInventory.func_146272_n()) {
            // empty if block
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private void cooldown(Item stack, EntityPlayer player, int ticks) {
        player.func_184811_cZ().func_185145_a(stack, ticks);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (ItemSonic.getOpen(stack) == 1 && entityIn.field_70173_aa % 200 == 0) {
            ItemSonic.setOpen(stack, 0);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.tardis.sonic_screwdriver";
    }

    public static final class NBT {
        public static final String MODE_KEY = "mode";
        public static final String CHARGE_KEY = "charge";
        public static final String CONSOLE_POS = "console_pos";
        public static final String SPECIAL = "special";
        public static final String OPEN = "open";
    }
}

